/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.graphics.BitmapFileHeader;
import com.jmorgan.graphics.BitmapInfo;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Windows3DIB {
    private File file;
    private BitmapFileHeader bitmapFileHeader;
    private BitmapInfo bitmapInfo;
    private Color[] imagePixels;

    public Windows3DIB(String fileName) throws InstantiationException, IOException {
        this.file = new File(fileName);
        if (!this.file.exists()) {
            throw new InstantiationException(fileName + " does not exist!");
        }
        if (!this.file.canRead()) {
            throw new InstantiationException(fileName + ": Read permission not granted!");
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        this.bitmapFileHeader = new BitmapFileHeader();
        this.bitmapInfo = new BitmapInfo();
        this.bitmapFileHeader.read(raf);
        this.bitmapInfo.read(raf);
        long imageSize = this.bitmapInfo.getBitmapInfoHeader().getImageSize();
        byte[] signedBytes = new byte[(int)imageSize];
        raf.read(signedBytes);
        raf.close();
        Color[] colorTable = this.bitmapInfo.getColors();
        Color[] tempPixels = new Color[(int)imageSize * 2];
        int i = 0;
        int z = 0;
        while ((long)i < imageSize) {
            int unsignedByte = signedBytes[i] & 0xFF;
            tempPixels[z++] = colorTable[(unsignedByte & 0xF0) >> 4];
            tempPixels[z++] = colorTable[unsignedByte & 0xF];
            ++i;
        }
        int width = (int)this.getBitmapWidth();
        int height = (int)this.getBitmapHeight();
        this.imagePixels = new Color[(int)imageSize * 2];
        int h = 0;
        int i2 = width * height - width;
        while (i2 >= 0) {
            int j = i2;
            while (j < i2 + width) {
                this.imagePixels[h++] = tempPixels[j];
                ++j;
            }
            i2 -= width;
        }
    }

    public File getFile() {
        return this.file;
    }

    public BitmapFileHeader getBitmapFileHeader() {
        return this.bitmapFileHeader;
    }

    public long getBitmapHeight() {
        return this.bitmapInfo.getBitmapInfoHeader().getBitmapHeight();
    }

    public BitmapInfo getBitmapInfo() {
        return this.bitmapInfo;
    }

    public long getBitmapWidth() {
        return this.bitmapInfo.getBitmapInfoHeader().getBitmapWidth();
    }

    public Color[] getImagePixels() {
        return this.imagePixels;
    }

    public String toString() {
        String s = String.valueOf(this.file.getAbsoluteFile()) + "\n" + this.bitmapFileHeader.toString() + "\n" + this.bitmapInfo.toString();
        return s;
    }
}

