/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.Drawer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;

public abstract class AbstractDrawer
implements Drawer {
    private Point location;
    private Dimension size;
    private FontRenderContext fontRenderContext;

    public AbstractDrawer() {
    }

    public AbstractDrawer(Point location, Dimension size) {
        this.setLocation(location);
        this.setSize(size);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.fontRenderContext = g2.getFontRenderContext();
        }
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setLocation(Point location) {
        this.location = location;
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }
}

