/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.FileReaderHelper;
import com.jmorgan.util.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ASCFileReader {
    private String fileName;
    private ArrayList<String> data = new ArrayList();

    public ASCFileReader(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public ASCFileReader(String fileName) throws IOException {
        this.setFileName(fileName);
    }

    public void setFileName(String newFileName) throws IOException {
        this.fileName = newFileName;
        this.readData();
    }

    public Collection<String> getData() {
        return this.data;
    }

    private void readData() throws IOException {
        if (StringUtility.isEmpty(this.fileName)) {
            throw new FileNotFoundException("ASCFileReader.readData():  File Name is not set");
        }
        try {
            String line;
            FileReaderHelper fr = new FileReaderHelper(this.fileName);
            if (!fr.open()) {
                IOException e = fr.getException();
                throw e;
            }
            BufferedReader br = (BufferedReader)fr.getReader();
            do {
                if ((line = br.readLine()) == null) continue;
                this.data.add(line);
            } while (line != null);
            fr.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.err.println("ASCFileReader.readData():  Error processing: " + this.fileName);
            throw ioe;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String readAll() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.data) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }
}

