/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.IOColumnObject;
import com.jmorgan.util.collection.CollectionExecutor;
import java.util.Collection;

class IOColumnExecutor
extends CollectionExecutor<IOColumnObject> {
    static final int EXECUTE_COMMIT = 0;
    static final int EXECUTE_ROLLBACK = 1;
    private int executeType;

    public IOColumnExecutor(Collection<IOColumnObject> collection) throws NullPointerException {
        super(collection);
    }

    public IOColumnExecutor(Collection<IOColumnObject> collection, int executeType) throws NullPointerException {
        this(collection);
        this.setExecuteType(executeType);
    }

    @Override
    public void processElement(IOColumnObject column) {
        switch (this.executeType) {
            case 0: {
                column.commit();
                break;
            }
            case 1: {
                column.rollback();
            }
        }
    }

    void setExecuteType(int type) throws IllegalArgumentException {
        switch (type) {
            case 0: 
            case 1: {
                this.executeType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Execute type is invalid");
            }
        }
    }
}

