/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.nbit.NBit;
import com.jmorgan.io.AbstractNBitStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class NBitInputStream
extends AbstractNBitStream {
    private InputStream inputStream;

    public NBitInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("NBitInputStream must have a valid input stream.");
        }
        this.inputStream = inputStream;
        this.bitPosition = -1;
    }

    public NBit read(int numberOfBits) throws IOException {
        NBit value = new NBit();
        while (numberOfBits > 0) {
            try {
                value.append(this.getNextBit());
                --numberOfBits;
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException ioEx) {
                throw ioEx;
            }
        }
        return value;
    }

    private boolean getNextBit() throws IOException, EOFException {
        if (this.bitPosition == -1 || this.bitPosition == 7) {
            this.bitPosition = -1;
            this.currentByte = this.inputStream.read();
            if (this.currentByte == -1) {
                throw new EOFException();
            }
        }
        ++this.bitPosition;
        return (this.currentByte & BITMASK[this.bitPosition]) == BITMASK[this.bitPosition];
    }
}

