/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.j2ee.xml;

import com.jmorgan.util.StringUtility;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XMLFormatter {
    private XMLFormatter() {
    }

    public static String format(String xml) {
        xml = xml.trim();
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domLoadSave = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer serializer = domLoadSave.createLSSerializer();
            DOMConfiguration domConfiguration = serializer.getDomConfig();
            domConfiguration.setParameter("format-pretty-print", true);
            domConfiguration.setParameter("xml-declaration", true);
            domConfiguration.setParameter("element-content-whitespace", true);
            String formattedXML = serializer.writeToString(document);
            if (formattedXML.trim().startsWith("<?")) {
                int endOfPI = formattedXML.indexOf("?>");
                formattedXML = StringUtility.insertInto("\n", formattedXML, endOfPI + 2);
            }
            return formattedXML;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

