/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.AbstractMethodInvoker;
import com.jmorgan.lang.BenignStackTraceException;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.util.ThreadUtility;
import java.lang.reflect.Method;

public class AsynchMethodInvoker<RT>
extends AbstractMethodInvoker<RT>
implements Runnable {
    private static final long AMI_EPOCH = System.nanoTime();
    private String threadName;
    private int delay;
    private long invocationStarted;
    private long invocationComplete;

    public AsynchMethodInvoker(Class<?> type, Method method) {
        this(type, method, new Object[0], 0);
    }

    public AsynchMethodInvoker(Object object, Method method) {
        this(object, method, new Object[0], 0);
    }

    public AsynchMethodInvoker(Class<?> type, Method method, int delay) {
        this(type, method, new Object[0], delay);
    }

    public AsynchMethodInvoker(Object object, Method method, int delay) {
        this(object, method, new Object[0], delay);
    }

    public AsynchMethodInvoker(Class<?> type, Method method, Object argument) {
        this(type, method, new Object[]{argument}, 0);
    }

    public AsynchMethodInvoker(Object object, Method method, Object argument) {
        this(object, method, new Object[]{argument}, 0);
    }

    public AsynchMethodInvoker(Class<?> type, Method method, Object argument, int delay) {
        this(type, method, new Object[]{argument}, delay);
    }

    public AsynchMethodInvoker(Object object, Method method, Object argument, int delay) {
        this(object, method, new Object[]{argument}, delay);
    }

    public AsynchMethodInvoker(Class<?> type, Method method, Object[] arguments) {
        this(type, method, arguments, 0);
    }

    public AsynchMethodInvoker(Object object, Method method, Object[] arguments) {
        this(object, method, arguments, 0);
    }

    public AsynchMethodInvoker(Class<?> type, Method method, Object[] arguments, int delay) {
        super(type, method, arguments);
        this.delay = delay;
        this.invokeMethod();
    }

    public AsynchMethodInvoker(Object object, Method method, Object[] arguments, int delay) {
        super(object, method, arguments);
        this.delay = delay;
        this.invokeMethod();
    }

    public AsynchMethodInvoker(Class<?> type, String methodName) {
        this(type, methodName, new Object[0], 0);
    }

    public AsynchMethodInvoker(Object object, String methodName) {
        this(object, methodName, new Object[0], 0);
    }

    public AsynchMethodInvoker(Class<?> type, String methodName, int delay) {
        this(type, methodName, new Object[0], delay);
    }

    public AsynchMethodInvoker(Object object, String methodName, int delay) {
        this(object, methodName, new Object[0], delay);
    }

    public AsynchMethodInvoker(Class<?> type, String methodName, Object argument) {
        this(type, methodName, new Object[]{argument}, 0);
    }

    public AsynchMethodInvoker(Object object, String methodName, Object argument) {
        this(object, methodName, new Object[]{argument}, 0);
    }

    public AsynchMethodInvoker(Class<?> type, String methodName, Object argument, int delay) {
        this(type, methodName, new Object[]{argument}, delay);
    }

    public AsynchMethodInvoker(Object object, String methodName, Object argument, int delay) {
        this(object, methodName, new Object[]{argument}, delay);
    }

    public AsynchMethodInvoker(Class<?> type, String methodName, Object[] arguments) {
        this(type, methodName, arguments, 0);
    }

    public AsynchMethodInvoker(Object object, String methodName, Object[] arguments) {
        this(object, methodName, arguments, 0);
    }

    public AsynchMethodInvoker(Class<?> type, String methodName, Object[] arguments, int delay) {
        super(type, methodName, arguments);
        this.delay = delay;
        this.invokeMethod();
    }

    public AsynchMethodInvoker(Object object, String methodName, Object[] arguments, int delay) {
        super(object, methodName, arguments);
        this.delay = delay;
        this.invokeMethod();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public boolean hasStarted() {
        return this.invocationStarted > 0L;
    }

    public long getInvocationStarted() {
        return this.invocationStarted;
    }

    public long getInvocationComplete() {
        return this.invocationComplete;
    }

    public long getInvocationTimeElapsed() {
        return this.invocationComplete - this.invocationStarted;
    }

    public void invokeMethod() {
        if (AsynchMethodInvoker.getDebug()) {
            new StackTrace(new BenignStackTraceException());
        }
        this.createThreadName();
        Thread t = new Thread((Runnable)this, this.threadName);
        t.start();
    }

    private void createThreadName() {
        long threadID = System.nanoTime() - AMI_EPOCH;
        if (this.threadName == null) {
            Method method = this.getMethod();
            String invoker = null;
            BenignStackTraceException path = new BenignStackTraceException();
            StackTraceElement[] elements = path.getStackTrace();
            invoker = String.format("%s.%s(%s:%d)", elements[3].getClassName(), elements[3].getMethodName(), elements[3].getFileName(), elements[3].getLineNumber());
            this.threadName = String.format("%s->%s.%s[%s]", invoker, method.getDeclaringClass().getName(), method.getName(), threadID);
        } else {
            this.threadName = String.format("%s[%d]", this.threadName, threadID);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void run() {
        this.hasCompleted = false;
        this.returnValue = null;
        if (this.delay > 0) {
            ThreadUtility.sleep(this.delay);
        }
        if (this.cancel) {
            return;
        }
        this.invocationStarted = System.nanoTime();
        this.returnValue = this.invoke();
        this.invocationComplete = System.nanoTime();
        this.hasCompleted = true;
    }
}

