/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.DateTime;
import java.lang.reflect.Method;

public class InvocationEvent
extends JMBean
implements Comparable<InvocationEvent> {
    private DateTime creationTime;
    private DateTime cancelledTime;
    private DateTime invocationTime;
    private DateTime invocationCompletedTIme;
    private Object invocationTarget;
    private Method method;
    private Object[] methodArguments;
    private Class<?> returnValueType;
    private Object returnValue;
    private boolean hasReturnValue;
    private boolean cancelled;

    private InvocationEvent() {
    }

    public InvocationEvent(Object invocationTarget, Method method) {
        this(invocationTarget, method, null, null, null);
        this.setHasReturnValue(false);
    }

    public InvocationEvent(Object invocationTarget, Method method, Object[] arguments) {
        this(invocationTarget, method, arguments, null, null);
        this.setHasReturnValue(false);
    }

    public InvocationEvent(Object invocationTarget, Method method, Object[] arguments, Class<?> returnType, Object returnValue) {
        this();
        this.setInvocationTarget(invocationTarget);
        this.setMethod(method);
        this.setMethodArguments(arguments);
        if (returnType != null && !returnType.getName().equals("void")) {
            this.setReturnValueType(returnType);
            this.setReturnValue(returnValue);
            this.setHasReturnValue(true);
        }
    }

    public DateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(DateTime creationTime) {
        this.creationTime = creationTime;
    }

    public DateTime getCancelledTime() {
        return this.cancelledTime;
    }

    public void setCancelledTime(DateTime cancelledTime) {
        this.cancelledTime = cancelledTime;
    }

    public DateTime getInvocationTime() {
        return this.invocationTime;
    }

    public void setInvocationTime(DateTime invocationTime) {
        this.invocationTime = invocationTime;
    }

    public DateTime getInvocationCompletedTIme() {
        return this.invocationCompletedTIme;
    }

    public void setInvocationCompletedTIme(DateTime invocationCompletedTIme) {
        this.invocationCompletedTIme = invocationCompletedTIme;
    }

    public Object getInvocationTarget() {
        return this.invocationTarget;
    }

    public void setInvocationTarget(Object invocationTarget) {
        this.invocationTarget = invocationTarget;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Object[] getMethodArguments() {
        return this.methodArguments;
    }

    public void setMethodArguments(Object[] methodArguments) {
        this.methodArguments = methodArguments;
    }

    public Class<?> getReturnValueType() {
        return this.returnValueType;
    }

    public void setReturnValueType(Class<?> returnValueType) {
        this.returnValueType = returnValueType;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public boolean hasReturnValue() {
        return this.hasReturnValue;
    }

    public void setHasReturnValue(boolean hasReturnValue) {
        this.hasReturnValue = hasReturnValue;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public int compareTo(InvocationEvent that) {
        Class<?>[] thatParmTypes;
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        int cmp = this.invocationTarget.getClass().getName().compareTo(that.invocationTarget.getClass().getName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.method.getName().compareTo(that.method.getName());
        if (cmp != 0) {
            return cmp;
        }
        Class<?>[] thisParmTypes = this.method.getParameterTypes();
        cmp = thisParmTypes.length - (thatParmTypes = that.method.getParameterTypes()).length;
        if (cmp != 0) {
            return cmp;
        }
        int i = 0;
        while (i < thisParmTypes.length) {
            cmp = thisParmTypes[i].getName().compareTo(thatParmTypes[i].getName());
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof InvocationEvent) {
            InvocationEvent that = (InvocationEvent)o;
            return this.areEqual(this.invocationTarget.getClass().getName(), that.invocationTarget.getClass().getName()) && this.areEqual(this.method.getName(), that.getMethod().getName()) && this.method.getParameterTypes().equals(that.method.getParameterTypes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BeanService.getHashCode(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("The method \"");
        sb.append(this.getMethod().getName());
        sb.append('\"');
        if (this.cancelled) {
            sb.append(" was cancelled");
        }
        if (!this.cancelled && this.invocationTime == null) {
            sb.append(" is being invoked");
        }
        if (this.invocationTime != null) {
            sb.append(" was invoked at ");
            sb.append(this.getInvocationTime());
        }
        sb.append(" on an instance of ");
        sb.append(this.getInvocationTarget().getClass().getName());
        if (this.methodArguments != null && this.methodArguments.length > 0) {
            sb.append(" with the following parameters:\n");
            Object[] objectArray = this.methodArguments;
            int n = this.methodArguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                sb.append("\t");
                if (arg instanceof String || arg instanceof StringBuilder || arg instanceof StringBuffer) {
                    sb.append("\"");
                }
                sb.append(arg);
                if (arg instanceof String || arg instanceof StringBuilder || arg instanceof StringBuffer) {
                    sb.append("\"");
                }
                sb.append("\n");
                ++n2;
            }
        }
        if (this.hasReturnValue()) {
            sb.append(" and returned ");
            sb.append(this.getReturnValue());
        }
        return sb.toString();
    }
}

