/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MultiThreadInvocationListener
implements InvocationListener {
    private int threadCount;
    private Vector<AsynchMethodInvoker> threads = new Vector();

    public MultiThreadInvocationListener() {
    }

    public MultiThreadInvocationListener(AsynchMethodInvoker<?> thread) {
        this();
        this.addThread(thread);
    }

    public synchronized void addThread(AsynchMethodInvoker<?> thread) {
        ++this.threadCount;
        thread.addInvocationListener(this);
        this.threads.add(thread);
    }

    public synchronized void addThreads(List<AsynchMethodInvoker> threads) {
        if (CollectionUtility.isNotEmpty(threads)) {
            this.threadCount += threads.size();
            this.threads.addAll(threads);
        }
    }

    public Vector<AsynchMethodInvoker> getThreads() {
        return this.threads;
    }

    public void clearCompleted() {
        if (CollectionUtility.isEmpty(this.threads)) {
            return;
        }
        try {
            Vector<AsynchMethodInvoker> looper = new Vector<AsynchMethodInvoker>(this.threads);
            for (AsynchMethodInvoker thread : looper) {
                if (thread == null || !thread.hasCompleted()) continue;
                this.threads.remove(thread);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetThreadCount() {
        this.threadCount = 0;
        this.threads.clear();
    }

    public boolean isComplete() {
        return this.threadCount == 0;
    }

    public int getRunningThreadCount() {
        int runningThreadCount = 0;
        ArrayList<AsynchMethodInvoker> threadList = new ArrayList<AsynchMethodInvoker>(this.threads);
        for (AsynchMethodInvoker ami : threadList) {
            if (!ami.hasStarted() || ami.hasCompleted()) continue;
            ++runningThreadCount;
        }
        return runningThreadCount;
    }

    public boolean waitToStart() {
        return this.waitToStart(60000);
    }

    public boolean waitToStart(int waitTimeout) {
        long endTime = System.currentTimeMillis() + (long)waitTimeout;
        while (this.getRunningThreadCount() == 0 && System.currentTimeMillis() < endTime) {
            ThreadUtility.sleep(50L);
        }
        return this.threadCount > 0;
    }

    public boolean waitUntilComplete() {
        return this.waitUntilComplete(60000);
    }

    public boolean waitUntilComplete(int waitTimeout) {
        long endTime = System.currentTimeMillis() + (long)waitTimeout;
        while (this.getRunningThreadCount() > 0 && System.currentTimeMillis() < endTime) {
            ThreadUtility.sleep(50L);
        }
        return this.getRunningThreadCount() == 0;
    }

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        return true;
    }

    @Override
    public synchronized void methodInvoked(InvocationEvent invocationEvent) {
        --this.threadCount;
    }

    @Override
    public synchronized void methodInvocationCancelled(InvocationEvent invocationEvent) {
        --this.threadCount;
    }

    public synchronized void showActiveThreads() {
        for (AsynchMethodInvoker thread : this.threads) {
            if (thread.hasCompleted()) continue;
            Object[] processArgs = thread.getArguments();
            System.out.printf("MultiThreadInvocationListener.showActiveThreads():  Thread Still Active: %s\n", thread.getThreadName());
            if (processArgs == null) continue;
            Object[] objectArray = processArgs;
            int n = processArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                System.out.printf("\t\t\t\t\tProcess Arg: [%s]\n", String.valueOf(arg));
                ++n2;
            }
        }
    }
}

