/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Types {
    private static final Class<?>[] primitives = new Class[]{Short.TYPE, Character.TYPE, Byte.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] wrappers = new Class[]{Short.class, Character.class, Byte.class, Integer.class, Long.class, Float.class, Double.class};
    private static final Class<?>[] bigWrappers = new Class[]{BigInteger.class, BigDecimal.class};

    private Types() {
    }

    public static boolean isPrimitive(Object value) {
        if (value == null) {
            throw new NullPointerException("Types.isPrimitive(Object value):  Value cannot be null.");
        }
        Class<?> type = value.getClass();
        return Types.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return type.equals(Boolean.class) || type.equals(Byte.class) || type.equals(Character.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(Void.class);
    }

    public static boolean isString(Object value) {
        Class<?> type = value.getClass();
        return Types.isStringType(type);
    }

    public static boolean isStringType(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(String.class) || type.equals(StringBuilder.class) || type.equals(StringBuffer.class);
    }

    public static Object getDefaultPrimitiveValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        return null;
    }

    public static boolean isBigNumberType(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(BigInteger.class) || type.equals(BigDecimal.class);
    }

    public static int getPrimitiveMatchWeight(Class<?> parameterType, Class<?> argumentType) {
        if (parameterType.equals(Boolean.TYPE) && !argumentType.equals(Boolean.class)) {
            return 0;
        }
        if (parameterType.equals(Boolean.TYPE) && argumentType.equals(Boolean.class)) {
            return 10;
        }
        if (parameterType.equals(Short.TYPE) && argumentType.equals(Character.class)) {
            return 0;
        }
        if (parameterType.equals(Character.TYPE) && argumentType.equals(Short.class)) {
            return 0;
        }
        int i = 0;
        while (i < primitives.length) {
            if (parameterType.equals(primitives[i])) break;
            ++i;
        }
        if (i == primitives.length) {
            throw new RuntimeException("i loop did not break in Types.getPrimitiveMatchWeight() for parmType of " + parameterType.getName());
        }
        int weight = 10;
        int j = i;
        while (j >= 0) {
            if (argumentType.equals(wrappers[j])) break;
            --j;
            --weight;
        }
        if (j == -1) {
            weight = 0;
        }
        return weight;
    }

    public static <T> T returnIfNull(T value, T valueIfNull) {
        return value == null ? valueIfNull : value;
    }
}

