/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import com.jmorgan.beans.JMBean;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class URLConnectionInfo
extends JMBean
implements Comparable<URLConnectionInfo> {
    private URLConnection connection;
    private String contentType;
    private String contentEncoding;
    private String contentCharset;
    private int contentLength;
    private Map<String, List<String>> headers;

    public URLConnectionInfo() {
    }

    public URLConnectionInfo(URLConnection connection) {
        this();
        this.setConnection(connection);
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public void setConnection(URLConnection connection) {
        this.connection = connection;
        this.setContentType(this.connection.getContentType());
        this.setContentEncoding(this.connection.getContentEncoding());
        this.setContentLength(this.connection.getContentLength());
        this.setHeaders(this.connection.getHeaderFields());
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentCharset() {
        int charSetPos;
        if (this.contentCharset == null && (charSetPos = this.contentType.indexOf("charset=")) >= 0) {
            this.contentCharset = this.contentType.substring(charSetPos + 8);
        }
        return this.contentCharset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public int compareTo(URLConnectionInfo that) {
        if (this.equals(that)) {
            return 0;
        }
        int cmp = this.compare((Comparable)((Object)this.contentType), (Comparable)((Object)that.contentType));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare((Comparable)((Object)this.contentEncoding), (Comparable)((Object)that.contentEncoding));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.contentLength - that.contentLength;
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof URLConnectionInfo) {
            URLConnectionInfo that = (URLConnectionInfo)o;
            return this.contentType.equals(that.contentType) && this.contentEncoding.equals(that.contentEncoding) && this.contentLength == that.contentLength && this.headers.equals(that.headers);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContentType: ");
        sb.append(this.contentType);
        sb.append("\n\tContentLength: ");
        sb.append(this.contentLength);
        sb.append("\n\tContentEncoding: ");
        sb.append(this.contentEncoding);
        Set<String> keys = this.headers.keySet();
        for (String key : keys) {
            sb.append("\n\tHeader: ");
            sb.append(key);
            for (String value : this.headers.get(key)) {
                sb.append("\n\t\t");
                sb.append(value);
            }
        }
        return sb.toString();
    }
}

