/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.rules;

import com.jmorgan.rules.Rule;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Pair;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.Collection;
import java.util.regex.Pattern;

public abstract class AbstractValueComparisonRule
implements Rule {
    public static final int IS_EQUAL_TO = 0;
    public static final int IS_NOT_EQUAL_TO = 1;
    public static final int IS_GREATER_THAN = 2;
    public static final int IS_LESS_THAN = 3;
    public static final int IS_GREATER_THAN_OR_EQUAL_TO = 4;
    public static final int IS_LESS_THAN_OR_EQUAL_TO = 5;
    public static final int MATCHES = 6;
    public static final int NOT_MATCHES = 7;
    public static final int IS_NULL = 8;
    public static final int IS_NOT_NULL = 9;
    public static final int IS_IN = 10;
    public static final int IS_NOT_IN = 11;
    public static final int BETWEEN = 12;
    public static final int NOT_BETWEEN = 13;
    protected static final String[] OPERATORS = new String[]{"=", "!=", ">", "<", ">=", "<=", "~", "!~", "is null", "is not null", "is in", "is not in", "between", "not between"};
    private AnyObjectComparator comparator = new AnyObjectComparator(1);

    protected AnyObjectComparator getComparator() {
        return this.comparator;
    }

    public boolean isTrue(Object source, int operator, Object value) {
        int comparison = this.comparator.compare(source, value);
        if (source instanceof Number || value instanceof Number) {
            comparison *= -1;
        }
        switch (operator) {
            case 8: {
                if (value == null) break;
                return false;
            }
            case 9: {
                if (value != null) break;
                return false;
            }
            case 0: {
                if (comparison == 0) break;
                return false;
            }
            case 1: {
                if (comparison != 0) break;
                return false;
            }
            case 2: {
                if (comparison > 0) break;
                return false;
            }
            case 3: {
                if (comparison < 0) break;
                return false;
            }
            case 4: {
                if (comparison >= 0) break;
                return false;
            }
            case 5: {
                if (comparison <= 0) break;
                return false;
            }
            case 10: {
                if (!(source instanceof Object[] ? !Comparison.isIn(value, (Object[])source) : source instanceof Collection && !Comparison.isIn(value, (Collection)source))) break;
                return false;
            }
            case 11: {
                if (!(source instanceof Object[] ? Comparison.isIn(value, (Object[])source) : source instanceof Collection && Comparison.isIn(value, (Collection)source))) break;
                return false;
            }
            case 6: {
                if (!(source instanceof String) || Pattern.matches((String)source, value.toString())) break;
                return false;
            }
            case 7: {
                if (!(source instanceof String) || !Pattern.matches((String)source, value.toString())) break;
                return false;
            }
            case 12: {
                if (!(source instanceof Pair)) break;
                Pair lowHigh = (Pair)source;
                if (Comparison.isBetween(value, lowHigh.first, lowHigh.second)) break;
                return false;
            }
            case 13: {
                if (!(source instanceof Pair)) break;
                Pair lowHigh = (Pair)source;
                if (!Comparison.isBetween(value, lowHigh.first, lowHigh.second)) break;
                return false;
            }
        }
        return true;
    }
}

