/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.rules;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.rules.Rule;
import com.jmorgan.util.comparator.CollectionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CompoundRule
extends JMBean
implements Rule {
    public static final int AND = 0;
    public static final int OR = 1;
    private ArrayList<Rule> rules = new ArrayList();
    private int logicalOperator;

    public CompoundRule() {
        this.setLogicalOperator(1);
    }

    public CompoundRule(Rule rule1, int operator, Rule rule2) {
        this();
        this.addRule(rule1);
        this.addRule(rule2);
        this.setLogicalOperator(operator);
    }

    public CompoundRule(Collection<Rule> rules, int operator) {
        this();
        this.rules.addAll(rules);
        this.setLogicalOperator(operator);
    }

    public CompoundRule(Rule[] rules, int operator) {
        this();
        List<Rule> ruleList = Arrays.asList(new Rule[0]);
        this.rules.addAll(ruleList);
    }

    public ArrayList<Rule> getRules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            return;
        }
        this.rules.add(rule);
    }

    public void removeRule(Rule rule) {
        if (rule == null) {
            return;
        }
        this.rules.remove(rule);
    }

    public int getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(int logicalOperator) throws IllegalArgumentException {
        switch (logicalOperator) {
            case 0: 
            case 1: {
                this.logicalOperator = logicalOperator;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value (" + logicalOperator + ") provided to " + this.getClass().getName() + " is not valid.");
            }
        }
    }

    @Override
    public boolean isTrue() {
        for (Rule rule : this.rules) {
            boolean ruleState = rule.isTrue();
            if (ruleState && this.logicalOperator == 1) {
                return true;
            }
            if (ruleState || this.logicalOperator != 0) continue;
            return false;
        }
        return this.logicalOperator != 1;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.logicalOperator;
        result = 31 * result + BeanService.getHashcodeOf(this.rules);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundRule that = (CompoundRule)obj;
        if (this.logicalOperator != that.logicalOperator) {
            return false;
        }
        CollectionComparator<Rule> comparator = new CollectionComparator<Rule>();
        int cmp = comparator.compare(this.rules, that.rules);
        return cmp == 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (Rule rule : this.rules) {
            sb.append(rule.toString());
            sb.append(this.logicalOperator == 1 ? " or " : " and ");
        }
        int len = sb.length();
        sb.setLength(this.logicalOperator == 1 ? len - 4 : len - 5);
        sb.append(")");
        return sb.toString();
    }
}

