/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.swing.decorator.Decorator;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.util.HoverBorderController;
import com.jmorgan.swing.util.HoverColorController;
import com.jmorgan.swing.util.LabelUtility;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class JMButton
extends JButton {
    private int toolTipXOffset;
    private int toolTipYOffset;
    private Insets insets;
    private Decorator decorator;
    private Paint backgroundPaint;
    private Paint borderPaint;
    private String iconName;
    private String disabledIconName;
    private String disabledSelectedIconName;
    private String pressedIconName;
    private String rolloverIconName;
    private String rollOverSelectedIconName;
    private String selectedIconName;
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;

    public JMButton() {
        this.standardInit();
    }

    public JMButton(String label) {
        super(label);
        LabelUtility.parseLabel(this);
        this.standardInit();
    }

    public JMButton(Icon icon) {
        super(icon);
        this.standardInit();
    }

    public JMButton(String label, Icon icon) {
        super(label, icon);
        LabelUtility.parseLabel(this);
        this.standardInit();
    }

    public JMButton(String label, String toolTipText) {
        this(label);
        this.setToolTipText(toolTipText);
    }

    public JMButton(Icon icon, String toolTipText) {
        this(icon);
        this.setToolTipText(toolTipText);
    }

    public JMButton(String label, Icon icon, String toolTipText) {
        this(label, icon);
        this.setToolTipText(toolTipText);
    }

    public JMButton(Decorator decorator) {
        this.setDecorator(decorator);
        this.standardInit();
    }

    public JMButton(Decorator decorator, String toolTipText) {
        this(decorator);
        this.setToolTipText(toolTipText);
    }

    private void standardInit() {
        Paint borderPaint;
        Paint paint;
        ShapeCreator shapeCreator;
        HoverBorderController buttonBorderRollover;
        HoverColorController buttonRollover;
        this.insets = new Insets(2, 8, 2, 8);
        this.toolTipYOffset = -1;
        this.toolTipXOffset = 20;
        this.setCursor(new Cursor(12));
        String label = this.getText();
        if (label != null) {
            this.setToolTipText(label);
        }
        if ((buttonRollover = (HoverColorController)UIManager.get("Button.backgroundHover")) != null) {
            buttonRollover.addComponent(this);
        }
        if ((buttonBorderRollover = (HoverBorderController)UIManager.get("Button.borderHover")) != null) {
            buttonBorderRollover.addComponent(this);
        }
        if ((shapeCreator = (ShapeCreator)UIManager.get("Button.shapeCreator")) != null) {
            this.setShapeCreator(shapeCreator);
        }
        if ((paint = (Paint)UIManager.get("Button.backgroundPaint")) != null) {
            this.setBackgroundPaint(paint);
        }
        if ((borderPaint = (Paint)UIManager.get("Button.borderPaint")) != null) {
            this.setBorderPaint(borderPaint);
        }
    }

    public void setActivator(JTextComponent activator, int keyCode) {
        KeyEventInvoker keyEventInvoker = new KeyEventInvoker((Object)activator, 402, this, "invokeOnKeyCode");
        keyEventInvoker.addKeyFilter(keyCode);
    }

    @Reflected
    private void invokeOnKeyCode() {
        this.grabFocus();
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    @Override
    public void setText(String text) {
        this.setMnemonic(0);
        super.setText(text);
        LabelUtility.parseLabel(this);
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.shapePainterDelegate = null;
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.shapePainterDelegate = null;
        super.setBounds(r);
    }

    @Override
    public void setSize(Dimension d) {
        this.shapePainterDelegate = null;
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        this.shapePainterDelegate = null;
        super.setSize(width, height);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return new Point(this.getToolTipXOffset(), this.getToolTipYOffset());
    }

    public int getToolTipXOffset() {
        return this.toolTipXOffset;
    }

    public void setToolTipXOffset(int newToolTipXOffset) {
        this.toolTipXOffset = newToolTipXOffset;
    }

    public int getToolTipYOffset() {
        if (this.toolTipYOffset == -1) {
            this.toolTipYOffset = this.getSize().height + 5;
        }
        return this.toolTipYOffset;
    }

    public void setToolTipYOffset(int newToolTipYOffset) {
        this.toolTipYOffset = newToolTipYOffset;
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapePainterDelegate = null;
        this.shapeCreator = shapeCreator;
    }

    public EventListenerList getEventListeners() {
        return this.listenerList;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String imageName) {
        this.iconName = imageName;
    }

    public String getDisabledIconName() {
        return this.disabledIconName;
    }

    public void setDisabledIconName(String disabledIconName) {
        this.disabledIconName = disabledIconName;
    }

    public String getDisabledSelectedIconName() {
        return this.disabledSelectedIconName;
    }

    public void setDisabledSelectedIconName(String disabledSelectedIconName) {
        this.disabledSelectedIconName = disabledSelectedIconName;
    }

    public String getPressedIconName() {
        return this.pressedIconName;
    }

    public void setPressedIconName(String pressedIconName) {
        this.pressedIconName = pressedIconName;
    }

    public String getRolloverIconName() {
        return this.rolloverIconName;
    }

    public void setRolloverIconName(String rolloverIconName) {
        this.rolloverIconName = rolloverIconName;
    }

    public String getRollOverSelectedIconName() {
        return this.rollOverSelectedIconName;
    }

    public void setRollOverSelectedIconName(String rollOverSelectedIconName) {
        this.rollOverSelectedIconName = rollOverSelectedIconName;
    }

    public String getSelectedIconName() {
        return this.selectedIconName;
    }

    public void setSelectedIconName(String selectedIconName) {
        this.selectedIconName = selectedIconName;
    }

    public void setInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(2, 8, 2, 8);
        }
        this.insets = insets;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.setContentAreaFilled(this.backgroundPaint == null && this.shapeCreator == null);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Paint oldPaint = null;
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            if (this.borderPaint != null) {
                oldPaint = g2d.getPaint();
                g2d.setPaint(this.borderPaint);
            }
        } else {
            g.setColor(UIManager.getColor("Button.darkShadow"));
        }
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
        if (this.borderPaint != null && g2d != null) {
            g2d.setPaint(oldPaint);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint oldPaint = null;
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            if (this.backgroundPaint != null) {
                oldPaint = g2d.getPaint();
                g2d.setPaint(this.backgroundPaint);
            } else {
                List gradient = (List)UIManager.get("Button.gradient");
                if (gradient != null) {
                    ArrayList<Float> stops = new ArrayList<Float>();
                    ArrayList<Color> colors = new ArrayList<Color>();
                    for (Object element : gradient) {
                        if (element instanceof Float) {
                            stops.add((Float)element);
                            continue;
                        }
                        if (!(element instanceof Color)) continue;
                        colors.add((Color)element);
                    }
                    if (stops.size() < colors.size()) {
                        stops.add(Float.valueOf(1.0f));
                    }
                    Collections.sort(stops);
                    float[] floatStops = new float[stops.size()];
                    int i = 0;
                    while (i < floatStops.length) {
                        floatStops[i] = ((Float)stops.get(i)).floatValue();
                        ++i;
                    }
                    int paintX = this.getSize().width / 2;
                    g2d.setPaint(new LinearGradientPaint(paintX, 0.0f, paintX, this.getSize().height, floatStops, colors.toArray(new Color[colors.size()])));
                }
            }
        } else {
            g.setColor(UIManager.getColor("Button.background"));
        }
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintComponent(g);
        }
        super.paintComponent(g);
        if (this.backgroundPaint != null && g2d != null) {
            g2d.setPaint(oldPaint);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.decorator != null) {
            this.decorator.paint(g, this);
        }
    }
}

