/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.util.LabelUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JMLabel
extends JLabel {
    private Object textAntiAliasRenderingHint;
    private Insets insets;
    private String imageName;

    public JMLabel() {
        this.standardInit();
    }

    public JMLabel(Icon image) {
        super(image);
        this.standardInit();
    }

    public JMLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.standardInit();
    }

    public JMLabel(String text) {
        super(text);
        this.standardInit();
    }

    public JMLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.standardInit();
    }

    public JMLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.standardInit();
    }

    public JMLabel(String text, Component component) {
        this(text);
        this.setLabelFor(component);
    }

    protected void standardInit() {
        this.setAntiAliasing(false);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getInsets() {
        if (this.insets == null) {
            return super.getInsets();
        }
        return this.insets;
    }

    @Override
    public Insets insets() {
        if (this.insets == null) {
            return super.insets();
        }
        return this.insets;
    }

    @Override
    public void setText(String text) {
        this.setDisplayedMnemonic(0);
        super.setText(text);
        LabelUtility.parseLabel(this);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setAntiAliasing(boolean state) {
        this.textAntiAliasRenderingHint = state ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntiAliasRenderingHint);
        }
        super.paintComponent(g);
    }
}

