/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;

public class JMProgressBar
extends JProgressBar {
    private int currentValue;

    public JMProgressBar() {
        this.standardInit();
    }

    public JMProgressBar(BoundedRangeModel model) {
        super(model);
        this.standardInit();
    }

    public JMProgressBar(int orient) {
        super(orient);
        this.standardInit();
    }

    public JMProgressBar(int min, int max) {
        super(min, max);
        this.standardInit();
    }

    public JMProgressBar(int orient, int min, int max) {
        super(orient, min, max);
        this.standardInit();
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void incrementValue() {
        this.setValue(this.currentValue + 1);
    }

    public void start(int minimum, int maximum) {
        this.setMinimum(minimum);
        this.setValue(minimum);
        this.setMaximum(minimum);
        this.setVisible(true);
    }

    @Override
    public synchronized void setValue(int n) {
        super.setValue(n);
        this.currentValue = n;
    }

    private void standardInit() {
        this.setPreferredSize(500, 20);
        this.paintString = true;
        this.progressString = null;
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            int x = this.getWidth() / 2;
            g2.setPaint(new GradientPaint(x, 0.0f, this.getForeground().brighter(), x, this.getHeight(), this.getForeground().darker()));
        }
        super.paint(g);
    }
}

