/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.text.CharacterFilteringDocumentFilter;
import com.jmorgan.swing.text.CurrencyDocumentFilter;
import com.jmorgan.swing.text.NumberDocumentFilter;
import com.jmorgan.swing.text.PercentDocumentFilter;
import com.jmorgan.util.StringUtility;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.text.PlainDocument;

public class NumberField
extends JMTextField {
    public static final String PLAIN_INTEGERFORMAT = "###0;-###0";
    public static final String INTEGERFORMAT = "#,##0;-#,##0";
    public static final String DECIMALFORMAT = "#0.0";
    public static final String CURRENCYFORMAT = "$#,##0.00;$-#,##0.00";
    public static final String MONEYFORMAT = "$#,##0.00;$-#,##0.00";
    public static final String PCTFORMAT = "##0.00%;-##0.00%";
    private double number = 0.0;
    private double oldNumber = 0.0;
    private String formatString = "";
    private NumberFormat formatter;
    private boolean constructing = true;
    private boolean validating;

    public NumberField() {
        this(0.0);
    }

    public NumberField(double number) {
        this(number, INTEGERFORMAT);
    }

    public NumberField(double number, int columns) {
        this(number);
        this.setColumns(columns);
    }

    public NumberField(String format) {
        this(0.0, format);
    }

    public NumberField(double number, String format) {
        this.setName("number");
        this.setColumns(10);
        this.setHorizontalAlignment(4);
        this.setNullRenderValue("0");
        this.setFormatString(format);
        this.setNumber(number);
        this.constructing = false;
    }

    public double getNumber() {
        return this.number;
    }

    public synchronized void setNumber(double n) {
        this.oldNumber = this.number;
        this.number = n;
        this.formatValue();
    }

    @Override
    public void firePropertyChange(String oldText, String newText) {
        if (this.validating) {
            return;
        }
        this.validating = true;
        this.validateValue();
        if (this.propertyChangeSupport != null && oldText != null && !oldText.equals(newText)) {
            String fieldName = this.getName();
            this.propertyChangeSupport.firePropertyChange(StringUtility.isEmpty(fieldName) ? "text" : fieldName, this.oldNumber, this.number);
        }
        this.validating = false;
    }

    @Override
    public void setObject(Object value) {
        if (value == null) {
            this.setNull(true);
            return;
        }
        if (value instanceof Number) {
            this.setNumber(((Number)value).doubleValue());
        } else {
            super.setObject(value);
        }
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String s) {
        this.formatString = s;
        this.setFormatter(new DecimalFormat(s));
        PlainDocument document = (PlainDocument)this.getDocument();
        CharacterFilteringDocumentFilter documentFilter = null;
        if (s.contains("$")) {
            documentFilter = new CurrencyDocumentFilter();
        } else if (s.contains("%")) {
            documentFilter = new PercentDocumentFilter();
        } else {
            documentFilter = new NumberDocumentFilter();
            Object filterString = "-+0123456789";
            if (s.contains(".")) {
                filterString = (String)filterString + ".";
            }
            if (s.contains(",")) {
                filterString = (String)filterString + ",";
            }
            documentFilter.setAllowedChars((String)filterString);
        }
        document.setDocumentFilter(documentFilter);
        if (!this.constructing) {
            this.formatValue();
        }
    }

    public NumberFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(NumberFormat formatter) {
        this.formatter = formatter;
        this.formatValue();
    }

    @Reflected
    public void validateValue() {
        String value;
        if (this.isNull()) {
            super.setText(this.getNullRenderValue());
        }
        if ((value = StringUtility.removeAllExcept(this.getText(), "0123456789-.+")).length() == 0) {
            value = "0";
        }
        double number = Double.parseDouble(value);
        if (this.formatString.contains("%")) {
            number /= 100.0;
        }
        this.setNumber(number);
    }

    private void formatValue() {
        if (this.isNull()) {
            super.setText(this.getNullRenderValue());
            return;
        }
        String formattedNumber = this.formatter.format(this.number);
        this.setText(formattedNumber);
    }
}

