/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class ScrollablePanel
extends JMPanel
implements Scrollable {
    private boolean autoResize = true;

    public ScrollablePanel() {
    }

    public ScrollablePanel(LayoutManager layout) {
        super(layout);
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    @Override
    public Component add(Component comp, int index) {
        super.add(comp, index);
        new ComponentEventInvoker(comp, 8, (Object)this, "resize");
        new AsynchMethodInvoker((Object)this, "resize");
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        new ComponentEventInvoker(comp, 8, (Object)this, "resize");
        new AsynchMethodInvoker((Object)this, "resize");
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        new ComponentEventInvoker(comp, 8, (Object)this, "resize");
        new AsynchMethodInvoker((Object)this, "resize");
    }

    @Override
    public Component add(Component comp) {
        super.add(comp);
        new ComponentEventInvoker(comp, 8, (Object)this, "resize");
        new AsynchMethodInvoker((Object)this, "resize");
        return comp;
    }

    @Override
    public Component add(String name, Component comp) {
        super.add(name, comp);
        new ComponentEventInvoker(comp, 8, (Object)this, "resize");
        new AsynchMethodInvoker((Object)this, "resize");
        return comp;
    }

    public void resize() {
        if (!this.autoResize) {
            return;
        }
        Dimension newSize = new Dimension(0, 0);
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager == null) {
            Component[] components;
            Component[] componentArray = components = this.getComponents();
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                Point location = component.getLocation();
                Dimension size = component.getSize();
                Insets insets = InsetsFactory.createFixedInsets(0);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    insets = jComponent.getInsets();
                }
                int rx = location.x + size.width + insets.left + insets.right;
                int ry = location.y + size.height + insets.top + insets.bottom;
                if (newSize.width < rx) {
                    newSize.width = rx;
                }
                if (newSize.height < ry) {
                    newSize.height = ry;
                }
                ++n2;
            }
        } else {
            newSize = layoutManager.preferredLayoutSize(this);
        }
        Insets insets = this.getInsets();
        newSize.width += insets.left + insets.right;
        newSize.height += insets.top + insets.bottom;
        this.setSize(newSize);
        this.setPreferredSize(newSize);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getMaxComponentSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension dimension = this.getMaxComponentSize();
        if (orientation == 0) {
            return visibleRect.width / dimension.width;
        }
        if (orientation == 1) {
            return visibleRect.height / dimension.height;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension dimension = this.getMaxComponentSize();
        return orientation == 0 ? dimension.width : dimension.height;
    }

    private Dimension getMaxComponentSize() {
        Component[] components;
        Dimension dimension = new Dimension(0, 0);
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            Dimension cSize = component.getSize();
            if (cSize.height > dimension.height) {
                dimension.height = cSize.height;
            }
            if (cSize.width > dimension.width) {
                dimension.width = cSize.width;
            }
            ++n2;
        }
        return dimension;
    }
}

