/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPaneListener
implements ChangeListener {
    private JTabbedPane client;
    private int selectedIndex;
    private int lastSelectedIndex;
    private String selectedTitle;
    private String lastSelectedTitle;
    private Component selectedTab;
    private Component lastSelectedTab;

    public TabbedPaneListener(JTabbedPane client) {
        this.client = client;
        client.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.lastSelectedIndex = this.selectedIndex;
        this.lastSelectedTitle = this.selectedTitle;
        this.lastSelectedTab = this.selectedTab;
        this.selectedIndex = this.client.getSelectedIndex();
        this.selectedTitle = this.client.getTitleAt(this.selectedIndex);
        this.selectedTab = this.client.getComponentAt(this.selectedIndex);
        this.tabChanged(this.lastSelectedTab, this.selectedTab);
    }

    public JTabbedPane getClient() {
        return this.client;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getLastSelectedIndex() {
        return this.lastSelectedIndex;
    }

    public String getSelectedTitle() {
        return this.selectedTitle;
    }

    public String getLastSelectedTitle() {
        return this.lastSelectedTitle;
    }

    public Component getSelectedTab() {
        return this.selectedTab;
    }

    public Component getLastSelectedTab() {
        return this.lastSelectedTab;
    }

    public void tabChanged(Component lastTab, Component tab) {
    }
}

