/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar;

import com.jmorgan.swing.style.BorderStyle;
import com.jmorgan.swing.style.ColorStyle;
import com.jmorgan.swing.style.ComponentStyle;
import com.jmorgan.swing.style.GUIStyle;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.swing.util.ComponentConstants;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class CalendarStyle
extends GUIStyle {
    public static final String NORMAL = "normal";
    public static final String HOLIDAY = "holiday";
    public static final String WEEKEND = "weekend";
    public static final String SELECTED = "selected";
    public static final String TODAY = "today";
    public static final String NONMONTH = "nonmonth";
    public static final String CALENDAR = "calendar";
    public static final String HOVER = "hover";
    private static CalendarStyle calendarStyle;

    public static CalendarStyle getInstance() {
        if (calendarStyle == null) {
            calendarStyle = new CalendarStyle();
        }
        return calendarStyle;
    }

    private CalendarStyle() {
        ColorStyle normalColor = new ColorStyle(ComponentConstants.backgroundColor, ComponentConstants.textColor);
        ColorStyle holidayColor = new ColorStyle(ComponentConstants.textColor, Color.GREEN.darker());
        ColorStyle weekendColor = new ColorStyle(ComponentConstants.backgroundColor, new Color(0, 112, 0).darker().darker());
        ColorStyle selectedColor = new ColorStyle(ComponentConstants.backgroundColor, ComponentConstants.textColor);
        ColorStyle todayColor = new ColorStyle(ComponentConstants.textColor, UIManager.getColor("List.selectionBackground"));
        ColorStyle nonMonthColor = new ColorStyle(Color.GRAY, ComponentConstants.textColor);
        ColorStyle hoverColor = new ColorStyle(ComponentConstants.backgroundColor, ComponentConstants.textColor.brighter());
        BorderStyle borderStyle = new BorderStyle(ComponentConstants.controlBorder);
        Font boldFont = new Font(ComponentConstants.textFont.getName(), 1, ComponentConstants.textFont.getSize());
        Border selectedBorder = BorderFactory.createLoweredBevelBorder();
        BorderStyle selectedStyle = new BorderStyle(selectedBorder);
        this.setStyle(NORMAL, new TextStyle(normalColor, borderStyle, ComponentConstants.textFont));
        this.setStyle(HOLIDAY, new TextStyle(holidayColor, borderStyle, ComponentConstants.textFont));
        this.setStyle(WEEKEND, new TextStyle(weekendColor, borderStyle, ComponentConstants.textFont));
        this.setStyle(SELECTED, new TextStyle(selectedColor, selectedStyle, ComponentConstants.textFont));
        this.setStyle(TODAY, new TextStyle(todayColor, borderStyle, boldFont));
        this.setStyle(NONMONTH, new TextStyle(nonMonthColor, borderStyle, ComponentConstants.textFont));
        this.setStyle(HOVER, new TextStyle(hoverColor, borderStyle, ComponentConstants.textFont));
        this.setStyle(CALENDAR, new ComponentStyle(normalColor, borderStyle));
    }
}

