/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.math.DateMath;
import com.jmorgan.swing.calendar.model.DailyRecurrencePattern;
import com.jmorgan.swing.calendar.model.MonthlyRecurrencePattern;
import com.jmorgan.swing.calendar.model.WeeklyRecurrencePattern;
import com.jmorgan.swing.calendar.model.YearlyRecurrencePattern;
import com.jmorgan.util.Date;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public abstract class RecurrencePattern
implements Serializable,
PropertyChangeNotifier {
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    public static final int YEARLY = 3;
    private int recurrenceFrequency;
    private boolean useFrequency;
    private Date startDate;
    private Date endDate;
    private int calculationBase;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static RecurrencePattern getInstance(Date startDate, int frequency, int type) throws IllegalArgumentException {
        switch (type) {
            case 0: {
                return new DailyRecurrencePattern(startDate, frequency);
            }
            case 1: {
                return new WeeklyRecurrencePattern(startDate, frequency);
            }
            case 2: {
                return new MonthlyRecurrencePattern(startDate, frequency);
            }
            case 3: {
                return new YearlyRecurrencePattern(startDate, frequency);
            }
        }
        throw new IllegalArgumentException("The given type (" + type + ") is invalid.");
    }

    public RecurrencePattern(Date startDate) {
        this(startDate, 1);
    }

    public RecurrencePattern(Date startDate, int frequency) {
        this.setStartDate(startDate);
        this.setRecurrenceFrequency(frequency);
    }

    public int getCalculationBase() {
        return this.calculationBase;
    }

    public long getDuration() {
        if (this.endDate == null) {
            return -1L;
        }
        switch (this.calculationBase) {
            case 0: {
                return DateMath.getDayDifference(this.startDate, this.endDate);
            }
            case 1: {
                return DateMath.getWeekDifference(this.startDate, this.endDate);
            }
            case 2: {
                return DateMath.getMonthDifference(this.startDate, this.endDate);
            }
            case 3: {
                return DateMath.getYearDifference(this.startDate, this.endDate);
            }
        }
        return -1L;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setStartDate(Date date) throws NullPointerException {
        if (date == null) {
            throw new NullPointerException("The starting date for a recurrence range cannot be null");
        }
        Date oldDate = this.startDate;
        this.startDate = date;
        this.propertyChangeSupport.firePropertyChange("recurrenceStartDate", oldDate, date);
    }

    public void setEndDate(Date date) throws IllegalArgumentException {
        if (date.isBefore(this.startDate)) {
            throw new IllegalArgumentException("The ending date " + String.valueOf(date) + " cannot be before the starting date of " + String.valueOf(this.startDate));
        }
        Date oldDate = this.endDate;
        this.endDate = date;
        this.propertyChangeSupport.firePropertyChange("recurrenceEndDate", oldDate, date);
    }

    public void setDuration(int duration) throws IllegalArgumentException {
        if (duration < 0) {
            throw new IllegalArgumentException("The given duration (" + duration + ") cannot be less than zero.");
        }
        Date endDate = this.endDate;
        if (this.endDate == null) {
            endDate = new Date();
        }
        endDate.setDate(this.startDate);
        switch (this.calculationBase) {
            case 0: {
                endDate.addDays(duration);
                break;
            }
            case 1: {
                endDate.addDays(duration * 7);
                break;
            }
            case 2: {
                endDate.addMonths(duration);
                break;
            }
            case 3: {
                endDate.addYears(duration);
            }
        }
        this.setEndDate(endDate);
    }

    public void setCalculationBase(int calculationBase) throws IllegalArgumentException {
        switch (calculationBase) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int oldCalculationBase = this.calculationBase;
                this.calculationBase = calculationBase;
                this.propertyChangeSupport.firePropertyChange("recurrenceCalculationBase", oldCalculationBase, calculationBase);
                long duration = this.getDuration();
                this.setDuration((int)duration);
                break;
            }
            default: {
                throw new IllegalArgumentException("The given calculation base of " + calculationBase + " is invalid.");
            }
        }
    }

    public boolean isValidDate(Date date) {
        return !date.isBefore(this.startDate) && !date.isAfter(this.endDate);
    }

    protected boolean isUsingFrequency() {
        return this.useFrequency;
    }

    protected void useAlternate() {
        this.useFrequency = false;
    }

    public int getRecurrenceFrequency() {
        return this.recurrenceFrequency;
    }

    public void setRecurrenceFrequency(int frequency) throws IllegalArgumentException {
        int oldFrequency = this.recurrenceFrequency;
        this.recurrenceFrequency = frequency;
        this.useFrequency = true;
        this.propertyChangeSupport.firePropertyChange("recurrenceFrequency", oldFrequency, frequency);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

