/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.swing.calendar.model.DateOccurrence;
import com.jmorgan.swing.calendar.model.RecurrencePattern;
import com.jmorgan.util.Date;
import java.util.ArrayList;

public class YearlyRecurrencePattern
extends RecurrencePattern {
    private ArrayList<DateOccurrence> dates = new ArrayList();

    public YearlyRecurrencePattern(Date startDate) {
        this(startDate, 1);
    }

    public YearlyRecurrencePattern(Date startDate, int frequency) {
        super(startDate, frequency);
    }

    @Override
    public boolean isValidDate(Date targetDate) {
        if (!super.isValidDate(targetDate)) {
            return false;
        }
        Date workingDate = (Date)this.getStartDate().clone();
        int workingYear = workingDate.getYear();
        int targetYear = targetDate.getYear();
        int freq = this.getRecurrenceFrequency();
        while (workingYear <= targetYear) {
            if (workingYear == targetYear) break;
            workingYear += freq;
        }
        if (workingYear > targetYear) {
            return false;
        }
        for (DateOccurrence dateOccurrence : this.dates) {
            workingDate.setDate(dateOccurrence.getMonth(), dateOccurrence.getDate(), targetYear);
            if (!workingDate.equals(targetDate)) continue;
            return true;
        }
        return false;
    }

    public DateOccurrence[] getDates() {
        return (DateOccurrence[])this.dates.toArray();
    }

    public void addDate(int month, int date) throws IllegalArgumentException {
        this.dates.add(new DateOccurrence(month, date));
    }

    public void removeDate(int month, int date) throws IllegalArgumentException {
        this.dates.remove(new DateOccurrence(month, date));
    }
}

