/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.panels;

import com.jmorgan.swing.calendar.CalendarSelectionListener;
import com.jmorgan.swing.calendar.CalendarSelectionListenerSupport;
import com.jmorgan.swing.calendar.CalendarSelectionListenerSupporter;
import com.jmorgan.swing.calendar.CalendarStyle;
import com.jmorgan.swing.calendar.DayContainer;
import com.jmorgan.swing.calendar.model.CalendarModel;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.swing.util.HoverStyleController;
import com.jmorgan.util.DateMetaData;
import java.util.Calendar;
import javax.swing.JComponent;

public abstract class DefaultDayContainer
implements DayContainer,
CalendarSelectionListenerSupport {
    protected static HoverStyleController styleController = new HoverStyleController();
    private Calendar today;
    private Calendar date;
    private Calendar selectedDate;
    private CalendarSelectionListenerSupporter listenerSupport = new CalendarSelectionListenerSupporter();
    private CalendarStyle calendarStyle = CalendarStyle.getInstance();
    private TextStyle normalStyle = (TextStyle)this.calendarStyle.getStyle("normal");
    private TextStyle todayStyle = (TextStyle)this.calendarStyle.getStyle("today");
    private TextStyle selectedStyle = (TextStyle)this.calendarStyle.getStyle("selected");
    private TextStyle nonMonthStyle = (TextStyle)this.calendarStyle.getStyle("nonmonth");
    private TextStyle weekendStyle = (TextStyle)this.calendarStyle.getStyle("weekend");
    private TextStyle holidayStyle = (TextStyle)this.calendarStyle.getStyle("holiday");

    public DefaultDayContainer() {
        JComponent uiComponent = this.getUIComponent();
        uiComponent.setFont(((TextStyle)this.calendarStyle.getStyle("normal")).getFont());
        this.date = this.today = Calendar.getInstance();
        uiComponent.setOpaque(true);
        uiComponent.setBorder(((TextStyle)this.calendarStyle.getStyle("normal")).getBorder().getBorder());
        styleController.setTextStyle((TextStyle)this.calendarStyle.getStyle("hover"));
        styleController.addComponent(uiComponent);
    }

    public Calendar getDate() {
        return this.date;
    }

    public Calendar getSelectedDate() {
        return this.selectedDate;
    }

    @Override
    public void setDate(Calendar date, Calendar selectedDate) {
        this.date = date;
        if (date == null) {
            return;
        }
        this.setSelectedDate(selectedDate);
        boolean styleSet = false;
        if (!DateMetaData.isWeekday(date)) {
            this.setDisplayStyle(this.weekendStyle);
            styleSet = true;
        }
        if (DateMetaData.isHoliday(date)) {
            this.setDisplayStyle(this.holidayStyle);
            styleSet = true;
        }
        if (date.get(2) == this.today.get(2) && date.get(5) == this.today.get(5) && date.get(1) == this.today.get(1)) {
            this.setDisplayStyle(this.todayStyle);
            styleSet = true;
        }
        if (date.get(2) == selectedDate.get(2) && date.get(5) == selectedDate.get(5) && date.get(1) == selectedDate.get(1)) {
            this.setDisplayStyle(this.selectedStyle);
            styleSet = true;
        }
        if (date.get(2) != selectedDate.get(2) || date.get(1) != selectedDate.get(1)) {
            this.setDisplayStyle(this.nonMonthStyle);
            styleSet = true;
        }
        if (!styleSet) {
            this.setDisplayStyle(this.normalStyle);
        }
    }

    @Override
    public void setSelectedDate(Calendar date) {
        this.selectedDate = date;
    }

    public abstract void setDisplayStyle(TextStyle var1);

    @Override
    public void addCalendarSelectionListener(CalendarSelectionListener listener) {
        this.listenerSupport.addCalendarSelectionListener(listener);
    }

    @Override
    public void removeCalendarSelectionListener(CalendarSelectionListener listener) {
        this.listenerSupport.removeCalendarSelectionListener(listener);
    }

    protected void sendCalendarSelectionEvent() {
        this.listenerSupport.fireCalendarSelectionEvent(this.date);
    }

    @Override
    public void setCalendarModel(CalendarModel model) {
        throw new UnsupportedOperationException("Not Supported");
    }
}

