/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.util.PropertyBinder;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.component.MiniCalculator;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;

public class CalculatorComboBoxController
extends ComboBoxController
implements PropertyChangeNotifier {
    private NumberSpinner numberSpinner;
    private MiniCalculator calculator;

    public CalculatorComboBoxController() {
        this(new NumberSpinner(new NumberField(0.0)), new MiniCalculator());
    }

    public CalculatorComboBoxController(NumberSpinner numberSpinner, MiniCalculator calculator) {
        super(numberSpinner, calculator, true);
        this.numberSpinner = numberSpinner;
        this.calculator = calculator;
        new PropertyBinder(this.calculator, "value", this.numberSpinner.getComponent(), "number");
        new ActionEventInvoker(this.calculator, this, "comboItemSelected");
        this.setToolTip("Display Calculator");
    }

    public double getValue() {
        return ((NumberField)this.numberSpinner.getComponent()).getNumber();
    }

    public void setValue(double value) {
        ((NumberField)this.numberSpinner.getComponent()).setNumber(value);
    }

    @Override
    public void invokeDropDown() {
        double value = ((NumberField)this.numberSpinner.getComponent()).getNumber();
        this.calculator.setValue(value);
    }

    public void addActionListener(ActionListener listener) {
        this.calculator.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.calculator.removeActionListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        ((NumberField)this.numberSpinner.getComponent()).addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        ((NumberField)this.numberSpinner.getComponent()).removePropertyChangeListener(listener);
    }
}

