/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.combobox.ComboBox;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.combobox.ComboBoxFormatter;
import com.jmorgan.swing.combobox.ListComboBoxController;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

public class ListComboBox
extends ComboBox {
    private ListComboBoxController cbxController;

    public ListComboBox() {
        this(new ArrayList());
    }

    public ListComboBox(Object[] items) {
        this(Arrays.asList(items));
    }

    public ListComboBox(Collection<?> items) {
        this(new JMTextField(), new JMList(new JMListModel(items)));
    }

    public ListComboBox(JTextField textField, JList list) {
        this(textField, list, false);
    }

    public ListComboBox(JTextField textField, JList list, boolean allowEditing) {
        this(new ListComboBoxController(textField, list, allowEditing));
    }

    public ListComboBox(ListComboBoxController controller) {
        super(controller);
    }

    @Override
    public void setController(ComboBoxController controller) {
        super.setController(controller);
        this.cbxController = (ListComboBoxController)controller;
    }

    public void setEditable(boolean state) {
        this.cbxController.setAllowEditing(state);
    }

    @Override
    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public ComboBoxFormatter getComponentFormatter() {
        return this.cbxController.getComponentFormatter();
    }

    public void setComponentFormatter(ComboBoxFormatter componentFormatter) {
        this.cbxController.setComponentFormatter(componentFormatter);
    }

    public JTextField getField() {
        return this.cbxController.getField();
    }

    public String getText() {
        return this.cbxController.getField().getText();
    }

    public JList getList() {
        return this.cbxController.getList();
    }

    public int getSelectedIndex() {
        return this.cbxController.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.cbxController.getSelectedValue();
    }

    public Object getItemAt(int index) {
        return this.cbxController.getItemAt(index);
    }

    public void setSelectedValue(Object value) {
        this.cbxController.setSelectedValue(value);
    }

    public void setSelectedIndex(int index) {
        this.cbxController.setSelectedIndex(index);
    }

    public void addItems(Collection items) {
        if (CollectionUtility.isEmpty(items)) {
            return;
        }
        for (Object item : items) {
            this.addItem(item);
        }
    }

    public void addItem(Object item) {
        if (item == null) {
            return;
        }
        ListModel lm = this.cbxController.getList().getModel();
        new MethodInvoker(lm, "addElement", item).invoke();
    }

    public void removeItem(Object item) {
        ListModel lm = this.cbxController.getList().getModel();
        new MethodInvoker(lm, "removeElement", item).invoke();
    }

    public void clearListModel() {
        this.getList().clearSelection();
        this.cbxController.clearListModel();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.cbxController != null) {
            this.cbxController.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.cbxController.removePropertyChangeListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.cbxController.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.cbxController.removeListSelectionListener(listener);
    }
}

