/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.Pair;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;

public class AccordionComponent
extends JMPanel {
    private HashMap<String, Pair<JMButton, Container>> categories;
    private String currentContainerName;
    private Container currentContainer;
    private ArrayList<ActionListener> actionListeners;
    private int maxPreferredWidth = Integer.MIN_VALUE;

    public AccordionComponent() {
        super(new VerticalFlowLayout(3, 1));
        this.categories = new HashMap();
    }

    @Override
    public void componentResized() {
        super.componentResized();
        this.setSelectedContainerSize(this.currentContainer);
    }

    public void addCategory(String name, Container container) {
        this.addCategory(name, null, container);
    }

    public void addCategory(String name, Icon icon, Container container) {
        JMButton categoryButton = new JMButton(name);
        categoryButton.setIconTextGap(10);
        if (icon != null) {
            categoryButton.setIcon(icon);
        }
        this.categories.put(name, new Pair<JMButton, Container>(categoryButton, container));
        new ActionEventInvoker(categoryButton, this, "categoryButtonClicked", name);
        if (this.currentContainer != null) {
            container.setVisible(false);
            container.setPreferredSize(new Dimension(container.getPreferredSize().width, 0));
        }
        this.add(categoryButton);
        this.add(container);
        Dimension preferredSize = container.getPreferredSize();
        this.maxPreferredWidth = Math.max(this.maxPreferredWidth, preferredSize.width);
        if (this.currentContainer == null) {
            this.currentContainer = container;
            this.currentContainerName = name;
            container.setVisible(true);
        } else {
            container.setVisible(false);
        }
        this.categoryButtonClicked(this.currentContainerName);
    }

    public JMButton getCategoryButton(String name) {
        Pair<JMButton, Container> categoryComponents = this.categories.get(name);
        if (categoryComponents == null) {
            return null;
        }
        return (JMButton)categoryComponents.first;
    }

    public Container getCategoryContainer(String name) {
        Pair<JMButton, Container> categoryComponents = this.categories.get(name);
        if (categoryComponents == null) {
            return null;
        }
        return (Container)categoryComponents.second;
    }

    public void removeCategory(String name) {
        Pair<JMButton, Container> menuInfo = this.categories.get(name);
        if (menuInfo == null) {
            return;
        }
        this.remove(menuInfo.getFirst());
        this.remove(menuInfo.getSecond());
        this.categories.remove(name);
        if (name.equals(this.currentContainerName)) {
            Set<String> categoryNames = this.categories.keySet();
            this.currentContainerName = categoryNames.iterator().next();
        }
        this.categoryButtonClicked(this.currentContainerName);
    }

    public void categoryButtonClicked(String name) {
        Pair<JMButton, Container> menuInfo = this.categories.get(name);
        Container selectedContainer = (Container)menuInfo.second;
        this.currentContainer.setVisible(false);
        this.setSelectedContainerSize(selectedContainer);
        selectedContainer.setVisible(true);
        if (this.actionListeners != null) {
            ActionEvent evt = new ActionEvent(this, 1001, name);
            for (ActionListener listener : this.actionListeners) {
                listener.actionPerformed(evt);
            }
        }
        this.currentContainer = selectedContainer;
        this.currentContainerName = name;
    }

    private void setSelectedContainerSize(Container selectedContainer) {
        Dimension menuSize = this.getSize();
        Insets menuInsets = this.getInsets();
        Pair<JMButton, Container> tokenCategory = this.categories.get(this.currentContainerName);
        JMButton button = (JMButton)tokenCategory.first;
        int tokenButtonHeight = button.getHeight();
        int numberOfCategories = this.categories.size();
        Dimension containerSize = new Dimension(this.maxPreferredWidth, menuSize.height - numberOfCategories * tokenButtonHeight - numberOfCategories - menuInsets.top - menuInsets.bottom);
        selectedContainer.setPreferredSize(containerSize);
        this.setPreferredSize(this.maxPreferredWidth + menuInsets.left + menuInsets.right, tokenButtonHeight);
        this.revalidate();
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (listener == null || this.actionListeners == null) {
            return;
        }
        this.actionListeners.remove(listener);
    }
}

