/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BoxLayout;

public class ObjectPropertyDisplayPanel<ObjectType>
extends JMPanel {
    private ObjectType objectToDisplay;
    private HashMap<String, String> propertyExpressions;
    private HashSet<String> propertiesToHide;

    public ObjectPropertyDisplayPanel(ObjectType objectToDisplay) {
        super(new BorderLayout());
        this.objectToDisplay = objectToDisplay;
        this.propertiesToHide = new HashSet();
        this.propertyExpressions = new HashMap();
        new AsynchMethodInvoker((Object)this, "createPanel");
    }

    public void addPropertyException(String propertyName) {
        this.propertiesToHide.add(propertyName);
    }

    public void addPropertyExpression(String propertyName, String expression) {
        this.propertyExpressions.put(propertyName, expression);
    }

    @Reflected
    private void createPanel() {
        ScrollablePanel propertyValuePanel = new ScrollablePanel(new BorderLayout(10, 1));
        JMPanel leftPanel = new JMPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JMPanel rightPanel = new JMPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        ArrayList<String> propertyNames = BeanService.getPropertyNames(this.objectToDisplay);
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            if (Comparison.isIn(propertyName, this.propertiesToHide)) continue;
            String expression = this.propertyExpressions.get(propertyName);
            Object value = BeanService.getPropertyValue(this.objectToDisplay, expression == null ? propertyName : expression);
            if (value instanceof String && StringUtility.isEmpty((String)value)) {
                value = " ";
            }
            leftPanel.add(new JMLabel(StringUtility.getDisplayableTitle(propertyName)));
            rightPanel.add(new JMLabel(String.valueOf(value)));
        }
        propertyValuePanel.add((Component)leftPanel, "West");
        propertyValuePanel.add((Component)rightPanel, "Center");
        this.add((Component)new JMScrollPane(propertyValuePanel), "Center");
    }
}

