/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.decorator.Decorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ShapedButton
extends JMButton {
    private Shape shape;
    private Dimension originalSize;

    public ShapedButton(Shape shape) {
        this.standardInit(shape);
    }

    public ShapedButton(String label, Shape shape) {
        super(label);
        this.standardInit(shape);
    }

    public ShapedButton(Icon icon, Shape shape) {
        super(icon);
        this.standardInit(shape);
    }

    public ShapedButton(String label, Icon icon, Shape shape) {
        super(label, icon);
        this.standardInit(shape);
    }

    public ShapedButton(String label, Shape shape, String toolTipText) {
        super(label, toolTipText);
        this.standardInit(shape);
    }

    public ShapedButton(Icon icon, Shape shape, String toolTipText) {
        super(icon, toolTipText);
        this.standardInit(shape);
    }

    public ShapedButton(String label, Icon icon, Shape shape, String toolTipText) {
        super(label, icon, toolTipText);
        this.standardInit(shape);
    }

    public ShapedButton(Shape shape, Decorator decorator) {
        super(decorator);
        this.standardInit(shape);
    }

    public ShapedButton(Shape shape, Decorator decorator, String toolTipText) {
        super(decorator, toolTipText);
        this.standardInit(shape);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    private void standardInit(Shape shape) {
        this.setShape(shape);
        this.setContentAreaFilled(false);
        Rectangle bounds = shape.getBounds();
        this.originalSize = new Dimension(bounds.width, bounds.height);
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        --size.width;
        --size.height;
        double xRatio = (double)size.width / (double)this.originalSize.width;
        double yRatio = (double)size.height / (double)this.originalSize.height;
        g2.scale(xRatio, yRatio);
        Paint borderPaint = this.getBorderPaint();
        if (borderPaint == null) {
            g.setColor(UIManager.getColor("Button.darkShadow"));
        } else if (g instanceof Graphics2D) {
            g2.setPaint(borderPaint);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.draw(this.shape);
        xRatio = (double)this.originalSize.width / (double)size.width;
        yRatio = (double)this.originalSize.height / (double)size.height;
        g2.scale(xRatio, yRatio);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        --size.width;
        --size.height;
        double xRatio = (double)size.width / (double)this.originalSize.width;
        double yRatio = (double)size.height / (double)this.originalSize.height;
        g2.scale(xRatio, yRatio);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getModel().isArmed()) {
            g.setColor(UIManager.getColor("Button.select"));
            g2.fill(this.shape);
        } else {
            Paint backgroundPaint = this.getBackgroundPaint();
            int paintX = this.originalSize.width / 2;
            if (backgroundPaint == null) {
                Object gradient = UIManager.get("Button.gradient");
                if (gradient instanceof List) {
                    List gradientElements = (List)gradient;
                    ArrayList<Float> stops = new ArrayList<Float>();
                    ArrayList<Color> colors = new ArrayList<Color>();
                    for (Object element : gradientElements) {
                        if (element instanceof Float) {
                            stops.add((Float)element);
                            continue;
                        }
                        if (!(element instanceof Color)) continue;
                        colors.add((Color)element);
                    }
                    if (stops.size() < colors.size()) {
                        stops.add(new Float(1.0f));
                    }
                    Collections.sort(stops);
                    float[] floatStops = new float[stops.size()];
                    int i = 0;
                    while (i < floatStops.length) {
                        floatStops[i] = ((Float)stops.get(i)).floatValue();
                        ++i;
                    }
                    backgroundPaint = new LinearGradientPaint(paintX, 0.0f, paintX, this.originalSize.height, floatStops, colors.toArray(new Color[colors.size()]));
                } else {
                    Color dark = UIManager.getColor("Button.background");
                    Color light = UIManager.getColor("Button.light");
                    backgroundPaint = new LinearGradientPaint(paintX, 0.0f, paintX, this.originalSize.height, new float[]{0.0f, 0.3f, 1.0f}, new Color[]{dark, light, dark});
                }
            }
            g2.setPaint(backgroundPaint);
            g2.fill(this.shape);
        }
        xRatio = (double)this.originalSize.width / (double)size.width;
        yRatio = (double)this.originalSize.height / (double)size.height;
        g2.scale(xRatio, yRatio);
        super.paintComponent(g);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.shape.contains(x, y);
    }
}

