/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import java.awt.Insets;

public class InsetsCustomizer
extends AbstractCustomizer<Insets, NumericalSliderComponent[]> {
    private NumericalSliderComponent left = this.getSlider("&Left", 0);
    private NumericalSliderComponent right = this.getSlider("&Right", 0);
    private NumericalSliderComponent top = this.getSlider("&Top", 0);
    private NumericalSliderComponent bottom = this.getSlider("&Bottom", 0);

    public InsetsCustomizer() {
        super(new VerticalFlowLayout(0));
        this.add(this.left);
        this.add(this.right);
        this.add(this.top);
        this.add(this.bottom);
        this.setEditor(new NumericalSliderComponent[]{this.left, this.right, this.top, this.bottom});
    }

    public InsetsCustomizer(Insets insets) {
        this();
        this.setInsetsObject(insets);
    }

    public Insets getInsetsObject() {
        return (Insets)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setInsetsObject((Insets)bean);
    }

    public void setInsetsObject(Insets insets) {
        this.left.setValue(insets.left);
        this.right.setValue(insets.right);
        this.top.setValue(insets.top);
        this.bottom.setValue(insets.bottom);
        super.setObject(insets);
    }

    private NumericalSliderComponent getSlider(String label, int value) {
        NumericalSliderComponent c = new NumericalSliderComponent(label, value, 0, 1000, 1);
        c.getLabel().setPreferredSize(50, 23);
        new PropertyChangeInvoker(c, this, "createNewInsets");
        return c;
    }

    @Reflected
    private void createNewInsets() {
        Insets insets = new Insets((int)this.top.getValue(), (int)this.left.getValue(), (int)this.bottom.getValue(), (int)this.right.getValue());
        this.setObject(insets);
    }
}

