/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.dialog.wizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.dialog.wizard.WizardPage;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.WindowEventInvoker;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.ThreadUtility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WizardDialog<ModelType>
extends JMDialog {
    private static boolean wizardCancelled;
    private static Cursor WAIT_CURSOR;
    private static Cursor NORMAL_CURSOR;
    private ModelType model;
    private JMPanel pagesPanel;
    private CardLayout cardLayout;
    private ArrayList<WizardPage<ModelType, ? extends JMPanel>> wizardPages;
    private int currentlyDisplayedPage;
    private JMPanel navPanel;
    private JMButton backButton;
    private JMButton nextButton;
    private JMButton cancelButton;

    static {
        WAIT_CURSOR = new Cursor(3);
        NORMAL_CURSOR = new Cursor(0);
    }

    public static boolean wasCancelled() {
        return wizardCancelled;
    }

    public WizardDialog(JFrame owner, String title) {
        super(owner, title);
    }

    public WizardDialog(JDialog owner, String title) {
        super(owner, title);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.cardLayout = new CardLayout();
        this.navPanel = this.createNavPanel();
        this.pagesPanel = new JMPanel(this.cardLayout);
        JMPanel mainPanel = new JMPanel(new BorderLayout(1, 10));
        mainPanel.setInsets(InsetsFactory.createFixedInsets(10));
        mainPanel.add((Component)this.pagesPanel, "Center");
        mainPanel.add((Component)this.navPanel, "South");
        this.contentPane.add(mainPanel);
        this.wizardPages = new ArrayList();
    }

    @Override
    protected boolean getInitialVisibility() {
        return false;
    }

    public void startWizard() {
        wizardCancelled = false;
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(this.getParent());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
    }

    @Override
    public void setupEventHandling() {
        new ActionEventInvoker(this.cancelButton, this, "cancelWizard");
        new ActionEventInvoker(this.backButton, this, "navigateBack");
        new ActionEventInvoker(this.nextButton, this, "navigateForward");
        new WindowEventInvoker((Object)this, 4, this, "cancelWizard");
    }

    @Override
    public int getCloseOperation() {
        return 2;
    }

    public ModelType getModel() {
        return this.model;
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    @Reflected
    private void cancelWizard() {
        int selection = JOptionPane.showConfirmDialog(this, "Leave this wizard?", "Close Wizard", 0);
        if (selection == 0) {
            wizardCancelled = true;
            WindowCloser.closeWindow(this);
        }
    }

    @Reflected
    private void navigateBack() {
        if (this.currentlyDisplayedPage == 0) {
            return;
        }
        while (!this.wizardPages.get(--this.currentlyDisplayedPage).doesPageApply()) {
        }
        WizardPage<ModelType, JMPanel> wp = this.wizardPages.get(this.currentlyDisplayedPage);
        this.manageButtonState();
        this.cardLayout.show(this.pagesPanel, wp.getName());
        this.repaint();
    }

    @Reflected
    private void navigateForward() {
        WizardPage<ModelType, JMPanel> currentPage = this.wizardPages.get(this.currentlyDisplayedPage);
        boolean dataValid = currentPage.isDataValid();
        if (!dataValid) {
            return;
        }
        if (currentPage.isFinalPage()) {
            this.completeWizard();
            return;
        }
        this.setCursor(WAIT_CURSOR);
        try {
            int wizardPageCount = this.wizardPages.size();
            WizardPage<ModelType, JMPanel> thisPage = this.wizardPages.get(this.currentlyDisplayedPage);
            thisPage.saveDataToModel();
            try {
                while (!this.wizardPages.get(++this.currentlyDisplayedPage).doesPageApply()) {
                }
                WizardPage<ModelType, JMPanel> wp = this.wizardPages.get(this.currentlyDisplayedPage);
                this.manageButtonState();
                wp.updateControls();
                this.cardLayout.show(this.pagesPanel, wp.getName());
            }
            catch (IndexOutOfBoundsException e) {
                new JMMessageBox(null, "Invalid Wizard Configuration", LabelUtility.wrapInHTML("\tThis wizaard has no more pages that apply.\n\n\tYou must have a final page that applies somewhere beyond the\n\tpage you were on.\n\nFix the code as it is incomplete or invalid.\n"));
                throw e;
            }
            this.repaint();
        }
        finally {
            this.setCursor(NORMAL_CURSOR);
        }
    }

    private void completeWizard() {
        WizardPage<ModelType, JMPanel> thisPage = this.wizardPages.get(this.currentlyDisplayedPage);
        thisPage.saveDataToModel();
        WindowCloser.closeWindow(this);
    }

    public void manageButtonState() {
        this.backButton.setVisible(this.currentlyDisplayedPage > 0);
        WizardPage<ModelType, JMPanel> wp = this.wizardPages.get(this.currentlyDisplayedPage);
        if (wp.isFinalPage()) {
            this.nextButton.setText("Finish");
        } else {
            this.nextButton.setText("Next");
        }
        this.nextButton.setEnabled(wp.isNextButtonEnabled());
    }

    public void addWizardPage(WizardPage<ModelType, ? extends JMPanel> page, String name) {
        this.addWizardPage(page, name, -1);
    }

    public void addWizardPage(WizardPage<ModelType, ? extends JMPanel> page, String name, int location) {
        while (!page.isReady()) {
            ThreadUtility.sleep(50L);
        }
        page.setName(name);
        if (location < 0) {
            this.wizardPages.add(page);
        } else {
            this.wizardPages.add(location, page);
        }
        page.setSize(this.getSize());
        this.pagesPanel.add(page, name);
        if (this.wizardPages.size() == 1) {
            page.updateControls();
            this.manageButtonState();
            this.cardLayout.show(this.pagesPanel, name);
            this.currentlyDisplayedPage = 0;
        }
    }

    private JMPanel createNavPanel() {
        JMPanel panel = new JMPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        this.cancelButton = new JMButton("Cancel");
        this.backButton = new JMButton("Back");
        this.nextButton = new JMButton("Next");
        panel.add(Box.createHorizontalGlue());
        panel.add(this.backButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.cancelButton);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.nextButton);
        return panel;
    }
}

