/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.dialog.wizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public abstract class WizardPage<ModelType, ControlsPanelType extends JMPanel>
extends JMPanel
implements InvocationListener {
    public static String LABEL_CONTENTS_DIRECTORY = "./";
    public static String FILE_NAME_PREFIX = "";
    public static String FILE_NAME_SUFFIX = "";
    protected WizardDialog parentDialog;
    private JMLabel infoLabel;
    protected ControlsPanelType controlsPanel;
    protected ModelType model;
    protected boolean isFinalPage = false;
    protected boolean isReady;

    public WizardPage(ModelType model) {
        this(model, null);
    }

    public WizardPage(ModelType model, String contentsOrFileName) {
        super(new BorderLayout(20, 1));
        this.setModel(model);
        this.infoLabel = new JMLabel();
        this.infoLabel.setHorizontalAlignment(2);
        this.infoLabel.setVerticalAlignment(1);
        this.infoLabel.setPreferredSize(200, 400);
        this.infoLabel.setInsets(InsetsFactory.createFixedInsets(10));
        CompoundBorder labelBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.infoLabel.setBorder(labelBorder);
        this.infoLabel.setOpaque(true);
        this.infoLabel.setBackground(UIManager.getColor("Label.background").brighter());
        this.add((Component)this.infoLabel, "West");
        this.setLabelContents(contentsOrFileName);
        AsynchMethodInvoker ccpCreator = new AsynchMethodInvoker((Object)this, "createControlsPanel", 100);
        ccpCreator.addInvocationListener(this);
    }

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        return true;
    }

    @Override
    public void methodInvoked(InvocationEvent invocationEvent) {
        this.controlsPanel = (JMPanel)invocationEvent.getReturnValue();
        this.add((Component)this.controlsPanel, "Center");
        this.isReady = true;
        new AsynchMethodInvoker((Object)this, "discoverParent", 125);
    }

    @Override
    public void methodInvocationCancelled(InvocationEvent invocationEvent) {
    }

    public ModelType getModel() {
        return this.model;
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean doesPageApply() {
        return true;
    }

    public boolean isNextButtonEnabled() {
        return true;
    }

    public boolean isCancelButtonVisible() {
        return !this.isFinalPage();
    }

    public boolean isDataValid() {
        return true;
    }

    public boolean isFinalPage() {
        return this.isFinalPage;
    }

    public void setFinalPage(boolean isFinalPage) {
        this.isFinalPage = isFinalPage;
        if (this.parentDialog != null) {
            this.parentDialog.manageButtonState();
        }
    }

    protected abstract void saveDataToModel();

    public void setLabelContents(String contentsOrFileName) {
        String labelContents = this.getLabelContents(contentsOrFileName);
        this.infoLabel.setText(labelContents);
    }

    protected String getLabelContents(String contentsOrFileName) {
        String suffix;
        if (contentsOrFileName == null) {
            contentsOrFileName = this.getClass().getSimpleName();
        } else if (StringUtility.containsIgnoreCase(contentsOrFileName, "<html>")) {
            return contentsOrFileName;
        }
        if (!LABEL_CONTENTS_DIRECTORY.endsWith("/")) {
            LABEL_CONTENTS_DIRECTORY = String.valueOf(LABEL_CONTENTS_DIRECTORY) + "/";
        }
        if (contentsOrFileName.endsWith(suffix = FILE_NAME_SUFFIX)) {
            suffix = "";
        }
        String fileName = String.format("%s%s%s%s%s", "/", LABEL_CONTENTS_DIRECTORY, FILE_NAME_PREFIX, contentsOrFileName, suffix);
        fileName = StringUtility.coalesce(fileName, "/");
        String contentsOrFile = contentsOrFileName;
        String actualFileName = fileName;
        Application.getApplication().getApplicationLogger().finer(() -> LMG.log("(contentsOrFileName=%s):  Full Resource Name: %s", () -> contentsOrFile, () -> actualFileName));
        InputStream in = this.getClass().getResourceAsStream(fileName);
        if (in != null) {
            try {
                int bufferLength;
                StringBuilder sb = new StringBuilder();
                byte[] buffer = new byte[32768];
                while ((bufferLength = in.read(buffer)) >= 0) {
                    sb.append(new String(buffer, 0, bufferLength));
                }
                String contents = sb.toString();
                return contents;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Application.getApplication().getApplicationLogger().config(() -> LMG.log("(contentsOrFileName=%s): Unable to find help file: %s", () -> contentsOrFile, () -> actualFileName));
        }
        return contentsOrFileName;
    }

    protected abstract ControlsPanelType createControlsPanel();

    protected void updateControls() {
    }

    @Reflected
    protected WizardDialog discoverParent() {
        if (this.parentDialog != null) {
            return this.parentDialog;
        }
        Application.getApplication().getApplicationLogger().finer("(): Starting");
        WizardDialog parent = GUIServices.getParentByType(this, WizardDialog.class);
        if (parent == null) {
            Application.getApplication().getApplicationLogger().info("(): Done, Did not find parent.  Trying again!");
            new AsynchMethodInvoker((Object)this, "discoverParent", 100);
            return parent;
        }
        Application.getApplication().getApplicationLogger().finer("(): Done, found parent!");
        this.setParentDialog(parent);
        return this.parentDialog;
    }

    protected void setParentDialog(WizardDialog dialog) {
        this.parentDialog = dialog;
    }
}

