/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.event;

import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.JMTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class FocusChangePropertyChangeNotifier
implements FocusListener {
    private String oldText;
    private String newText;
    private JTextComponent requestor;

    public FocusChangePropertyChangeNotifier(JTextComponent requestor) throws IllegalArgumentException {
        if (!(requestor instanceof JTextField || requestor instanceof JMTextField || requestor instanceof JPasswordField || requestor instanceof JMPasswordField || requestor instanceof JMTextArea)) {
            throw new IllegalArgumentException("The requestor for " + this.getClass().getName() + " must be a descendent of javax.swing.JTextComponent.");
        }
        requestor.addFocusListener(this);
        this.requestor = requestor;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.oldText = this.requestor.getText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.newText = this.requestor.getText();
        if (!this.oldText.equals(this.newText)) {
            if (this.requestor instanceof JMTextField) {
                ((JMTextField)this.requestor).firePropertyChange(this.oldText, this.newText);
            } else if (this.requestor instanceof JMPasswordField) {
                ((JMPasswordField)this.requestor).firePropertyChange(this.oldText, this.newText);
            } else if (this.requestor instanceof JMTextArea) {
                ((JMTextArea)this.requestor).firePropertyChange(this.oldText, this.newText);
            }
        }
    }
}

