/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.event;

import com.jmorgan.swing.event.AbstractMouseEventInvoker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseEventInvoker
extends AbstractMouseEventInvoker
implements MouseListener {
    public static final int MOUSE_CLICKED = 1;
    public static final int MOUSE_ENTERED = 2;
    public static final int MOUSE_EXITED = 4;
    public static final int MOUSE_PRESSED = 8;
    public static final int MOUSE_RELEASED = 16;
    private int clickCount = -1;

    public MouseEventInvoker(Object mouseObject, int eventMask, Object target, String methodName) {
        super(mouseObject, eventMask, target, methodName);
        this.setListenerAddRemoveMethodNames("addMouseListener", "removeMouseListener");
    }

    public MouseEventInvoker(Object mouseObject, int eventMask, Object target, String methodName, Object ... arguments) {
        super(mouseObject, eventMask, target, methodName, arguments);
        this.setListenerAddRemoveMethodNames("addMouseListener", "removeMouseListener");
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(int clickCount) {
        if (clickCount < 1) {
            clickCount = -1;
        }
        this.clickCount = clickCount;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.clickCount < 1) {
            this.invokeFor(e, 1);
        } else if (e.getClickCount() == this.clickCount) {
            this.invokeFor(e, 1);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.invokeFor(e, 2);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.invokeFor(e, 4);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.clickCount < 1) {
            this.invokeFor(e, 8);
        } else if (e.getClickCount() == this.clickCount) {
            this.invokeFor(e, 8);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.clickCount < 1) {
            this.invokeFor(e, 16);
        } else if (e.getClickCount() == this.clickCount) {
            this.invokeFor(e, 16);
        }
    }
}

