/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.swing.list.ImmutableListModel;
import com.jmorgan.swing.list.JMListModel;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ListModel;

public final class ListModelFactory {
    public static final boolean MUTABLE_LIST_MODEL = true;
    public static final boolean IMMUTABLE_LIST_MODEL = false;

    private ListModelFactory() {
    }

    public static ListModel createListModel(Object[] array) {
        return ListModelFactory.createListModel(array, false);
    }

    public static ListModel createListModel(Object[] array, boolean isMutable) {
        return ListModelFactory.createListModel(Arrays.asList(array), isMutable);
    }

    public static ListModel createListModel(Collection<?> c) {
        return ListModelFactory.createListModel(c, false);
    }

    public static ListModel createListModel(Collection<?> c, boolean isMutable) {
        if (isMutable) {
            return new JMListModel(c);
        }
        return new ImmutableListModel(c);
    }
}

