/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.swing.menu.MenuConstants;
import com.jmorgan.swing.menu.MenuItemProperties;
import com.jmorgan.swing.util.LabelUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class JMMenuItem
extends JMenuItem {
    private static int maxToolbarItemOrder = -1;
    private int toolbarItemOrder = -1;

    public JMMenuItem() {
        this.setFont(MenuConstants.menuFont);
    }

    public JMMenuItem(Icon icon) {
        this(icon, -1);
    }

    public JMMenuItem(Icon i, int toolbarItemOrder) {
        this();
        this.setIcon(i);
        this.setToolbarItemOrder(toolbarItemOrder);
    }

    public JMMenuItem(String s) {
        this();
        this.setText(s);
        LabelUtility.parseLabel(this);
    }

    public JMMenuItem(String s, KeyStroke a) {
        this(s);
        this.setAccelerator(a);
    }

    public JMMenuItem(String s, Icon i) {
        this(s, i, -1);
    }

    public JMMenuItem(String s, Icon i, int toolbarItemOrder) {
        this(s);
        this.setFont(MenuConstants.menuFont);
        this.setIcon(i);
        this.setToolbarItemOrder(toolbarItemOrder);
    }

    public JMMenuItem(String s, KeyStroke a, Icon i) {
        this(s, i, -1);
        this.setAccelerator(a);
    }

    public JMMenuItem(String s, KeyStroke a, Icon i, int toolbarItemOrder) {
        this(s, i, toolbarItemOrder);
        this.setAccelerator(a);
    }

    public JMMenuItem(MenuItemProperties properties) {
        this(properties.getLabel(), properties.getShortcut(), properties.getIcon(), properties.getToolbarItemOrder());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    protected Container getTopMenuContainer() {
        JMenuBar mb = this.getMenuBar();
        Container container = mb.getParent();
        while (!(container instanceof JFrame || container instanceof JInternalFrame || container instanceof JApplet)) {
            container = container.getParent();
        }
        return container;
    }

    protected JMenuBar getMenuBar() {
        JPopupMenu popup = (JPopupMenu)this.getParent();
        Component c = popup.getInvoker();
        while (!(c instanceof JMenuBar)) {
            if (c instanceof JMenu) {
                c = ((JMenu)c).getParent();
                continue;
            }
            if (!(c instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)c;
            c = popup.getInvoker();
        }
        return (JMenuBar)c;
    }

    public void setToolbarItemOrder(int newToolbarItemOrder) {
        if (maxToolbarItemOrder < newToolbarItemOrder) {
            maxToolbarItemOrder = newToolbarItemOrder;
        }
        if (newToolbarItemOrder == -1) {
            newToolbarItemOrder = maxToolbarItemOrder += 10;
        }
        this.toolbarItemOrder = newToolbarItemOrder;
    }

    public int getToolbarItemOrder() {
        return this.toolbarItemOrder;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public EventListenerList getEventListeners() {
        return this.listenerList;
    }

    public String getMenuFunction() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.getText());
        JPopupMenu popup = (JPopupMenu)this.getParent();
        Component c = popup.getInvoker();
        while (!(c instanceof JMenuBar)) {
            if (c instanceof JMenu) {
                labels.add(((JMenu)c).getText());
                c = ((JMenu)c).getParent();
                continue;
            }
            if (!(c instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)c;
            c = popup.getInvoker();
        }
        Collections.reverse(labels);
        StringBuilder sb = new StringBuilder();
        for (String label : labels) {
            sb.append(label.replaceAll("&", "And").replaceAll("[^A-Za-z0-9]", ""));
        }
        sb.setCharAt(0, sb.toString().toLowerCase().charAt(0));
        return sb.toString();
    }
}

