/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.JMToolBar;
import com.jmorgan.swing.menu.MenuBarService;
import com.jmorgan.swing.menu.ToolBarButton;
import com.jmorgan.util.StringUtility;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public final class ToolBarGenerator {
    private JToolBar toolBar;

    public ToolBarGenerator(JMenuBar menuBar) {
        this.toolBar = this.generateToolBar(menuBar);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private JToolBar generateToolBar(JMenuBar mb) {
        ArrayList<ToolBarItemCache> toolBarCache = new ArrayList<ToolBarItemCache>();
        MenuBarService ms = new MenuBarService(mb);
        Collection<JMenuItem> menuItems = ms.getMenuItems();
        for (JMenuItem item : menuItems) {
            Icon icon = item.getIcon();
            String toolTipText = item.getToolTipText();
            String actionCommand = item.getActionCommand();
            if (StringUtility.isEmpty(toolTipText)) {
                if (icon instanceof ImageIcon) {
                    ImageIcon iIcon = (ImageIcon)icon;
                    toolTipText = iIcon.getDescription();
                } else {
                    toolTipText = actionCommand;
                }
            }
            if (icon == null) continue;
            ToolBarItemCache toolBarItemCache = new ToolBarItemCache();
            toolBarItemCache.toolBarItem = new ToolBarButton(icon, toolTipText);
            toolBarItemCache.toolBarItem.setPreferredSize(new Dimension(20, 20));
            toolBarItemCache.toolBarItem.setActionCommand(actionCommand);
            toolBarItemCache.toolBarItem.setAssociatedMenuItem((JMMenuItem)item);
            if (item instanceof JMMenuItem) {
                JMMenuItem baseItem = (JMMenuItem)item;
                toolBarItemCache.toolBarItemOrder = baseItem.getToolbarItemOrder();
                EventListenerList listenerList = baseItem.getEventListeners();
                Object[] listeners = listenerList.getListenerList();
                int i = 0;
                while (i < listeners.length) {
                    if (listeners[i] instanceof ActionListener) {
                        toolBarItemCache.toolBarItem.addActionListener((ActionListener)listeners[i]);
                    }
                    ++i;
                }
            }
            toolBarCache.add(toolBarItemCache);
        }
        Collections.sort(toolBarCache);
        JMToolBar toolBar = new JMToolBar();
        for (ToolBarItemCache tic : toolBarCache) {
            toolBar.add(tic.toolBarItem);
        }
        return toolBar;
    }

    class ToolBarItemCache
    implements Comparable<ToolBarItemCache> {
        int toolBarItemOrder;
        ToolBarButton toolBarItem;

        ToolBarItemCache() {
        }

        @Override
        public int compareTo(ToolBarItemCache that) {
            return this.toolBarItemOrder - that.toolBarItemOrder;
        }
    }
}

