/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public class RoundedCornerTabbedUI
extends MetalTabbedPaneUI {
    private Color unselectedForeground;
    private boolean unselectedForegroundHardSet = false;
    private Color disabledBackground = Color.LIGHT_GRAY;
    private int fixedWidth = -1;
    private int fixedHeight = -1;

    public RoundedCornerTabbedUI() {
        this.unselectedForeground = this.getUnselectedForeground();
    }

    public int getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(int fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public int getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(int fixedHeight) {
        this.fixedHeight = fixedHeight;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    private Color getSelectedForeground(int tabIndex) {
        Color selectedFG = UIManager.getColor("TabbedPane.selectedForeground");
        if (selectedFG != null) {
            selectedFG = this.tabPane.getForegroundAt(tabIndex);
        }
        return selectedFG;
    }

    public Color getUnselectedForeground() {
        if (this.unselectedForegroundHardSet) {
            return this.unselectedForeground;
        }
        this.unselectedForeground = UIManager.getColor("TabbedPane.unselectedForeground");
        if (this.unselectedForeground == null) {
            UIManager.put("TabbedPane.unselectedForeground", Color.BLACK);
            this.unselectedForeground = Color.black;
        }
        return this.unselectedForeground;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (this.fixedHeight > -1) {
            return this.fixedHeight;
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (this.fixedWidth > -1) {
            return this.fixedWidth;
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        boolean contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        Color selectedColor = UIManager.getColor("TabbedPane.selected");
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        if (tabsOverlapBorder) {
            y -= tabAreaInsets.bottom;
        }
        h -= y - insets.top;
        if (this.tabPane.getTabCount() > 0 && (contentOpaque || this.tabPane.isOpaque())) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                g.setColor(color);
            } else if (selectedColor == null || selectedIndex == -1) {
                g.setColor(this.tabPane.getBackground());
            } else {
                g.setColor(selectedColor);
            }
            g.fillRect(x, y, w, h);
        }
        g.setColor(UIManager.getColor("TabbedPane.unselectedBackground"));
        g.drawRoundRect(x, y, w - 1, h - 1, 8, 8);
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.selectHighlight);
        g.drawLine(selRect.x + 1, selRect.y + selRect.height, selRect.x + selRect.width - 2, selRect.y + selRect.height);
    }

    public void setUnselectedForeground(Color unselectedForeground) {
        this.unselectedForeground = unselectedForeground;
        this.unselectedForegroundHardSet = true;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            Color selectedFG;
            Color fg = Color.BLACK;
            if (isSelected && (selectedFG = this.getSelectedForeground(tabIndex)) != null) {
                fg = selectedFG;
            }
            if (!isSelected && (selectedFG = this.getUnselectedForeground()) != null) {
                fg = selectedFG;
            }
            g.setColor(fg);
            g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
            g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
            g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int arcWidth = 8;
        int rectWidth = 16;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isSelected) {
            g.setColor(UIManager.getColor("TabbedPane.selected"));
        } else {
            g.setColor(UIManager.getColor("TabbedPane.unselectedBackground"));
        }
        if (!this.tabPane.isEnabledAt(tabIndex)) {
            g.setColor(UIManager.getColor("TabbedPane.disabledBackground"));
        }
        g.fillRect(x + 8, y + 1, w - 16, 8);
        g.fillRect(x + 1, y + 8, w - 2, h - 8);
        g.fillArc(x, y, 16, 16, 90, 90);
        g.fillArc(x + w - 1 - 16, y, 16, 16, 0, 90);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int bottom = h - 1;
        int right = w - 1;
        int arcWidth = 8;
        int rectWidth = 16;
        g.translate(x, y);
        g.setColor(UIManager.getColor("TabbedPane.darkShadow"));
        g.drawArc(right - 16, 0, 16, 16, 0, 90);
        g.drawLine(right - 8, 0, 9, 0);
        g.drawArc(0, 0, 16, 16, 90, 90);
        g.drawLine(0, 9, 0, bottom);
        g.drawLine(right, 8, right, bottom);
        g.translate(-x, -y);
    }
}

