/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.splitpane;

import com.jmorgan.swing.layout.AbstractLayout;
import com.jmorgan.swing.splitpane.SplitPaneDivider;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.UIManager;

public class SplitPaneLayout
extends AbstractLayout {
    private int maxRows = 0;
    private int maxColumns = 0;
    private ArrayList<Double> columnWidths;
    private ArrayList<Double> rowHeights;
    private int dividerSize = (Integer)UIManager.get("SplitPane.dividerSize");
    private HashMap<Pair<Integer, Integer>, Component> locationMap;

    public SplitPaneLayout(int rows, int columns) {
        this.maxRows = rows;
        this.maxColumns = columns;
        this.locationMap = new HashMap();
        this.columnWidths = new ArrayList();
        int c = 0;
        while (c < this.maxColumns) {
            this.columnWidths.add(0.0);
            ++c;
        }
        this.rowHeights = new ArrayList();
        int r = 0;
        while (r < this.maxRows) {
            this.rowHeights.add(0.0);
            ++r;
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public ArrayList<Double> getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidth(int col, double width) {
        this.columnWidths.set(col, width);
    }

    public ArrayList<Double> getRowHeights() {
        return this.rowHeights;
    }

    public void setRowHeight(int row, double height) {
        this.rowHeights.set(row, height);
    }

    public void setMaxColumns(int columns) {
        this.maxColumns = columns;
    }

    public Pair<Integer, Integer> getLocationOf(Component component) {
        Pair<Integer, Integer> componentLocation = null;
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            Component c = this.locationMap.get(location);
            if (c != component) continue;
            componentLocation = location;
            break;
        }
        return componentLocation;
    }

    public HashMap<Pair<Integer, Integer>, Component> getLocationMap() {
        return this.locationMap;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Component existingComp;
        if (comp instanceof SplitPaneDivider) {
            return;
        }
        Pair<Integer, Integer> location = (Pair<Integer, Integer>)constraints;
        int row = (Integer)location.first;
        int col = (Integer)location.second;
        if (row < 0 && col < 0) {
            Pair<Integer, Integer> nextLocation;
            location = nextLocation = this.getNextUsableLocation();
        }
        if ((existingComp = this.locationMap.get(location)) != null) {
            this.removeLayoutComponent(existingComp);
        }
        this.locationMap.put(location, comp);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        System.out.printf("SplitPaneLayout.addLayoutComponent(name=%s, comp=%s):   ******** NEED TO IMPLEMENT *********\n", name, comp.getClass().getSimpleName());
    }

    public Component getComponentAt(int row, int column) {
        Component component = this.locationMap.get(new Pair<Integer, Integer>(row, column));
        return component;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        Pair<Integer, Integer> locationToRemove = null;
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            Component c = this.locationMap.get(location);
            if (c != component) continue;
            locationToRemove = location;
            break;
        }
        if (locationToRemove != null) {
            int componentsInColumn;
            int rowOfRemoved = (Integer)locationToRemove.first;
            int colOfRemoved = (Integer)locationToRemove.second;
            this.locationMap.remove(locationToRemove);
            int componentsInRow = this.getComponentCountInRow(rowOfRemoved);
            if (componentsInRow == 0) {
                this.updateMissingRow(rowOfRemoved);
            }
            if ((componentsInColumn = this.getComponentCountInColumn(colOfRemoved)) == 0) {
                this.updateMissingColumn(colOfRemoved);
            }
        }
    }

    private int getComponentCountInColumn(int column) {
        int count = 0;
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            if ((Integer)location.second != column) continue;
            ++count;
        }
        return count;
    }

    private int getComponentCountInRow(int row) {
        int count = 0;
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            if ((Integer)location.first != row) continue;
            ++count;
        }
        return count;
    }

    private void updateMissingRow(int row) {
        HashMap<Pair<Integer, Integer>, Component> newMap = new HashMap<Pair<Integer, Integer>, Component>(this.locationMap.size());
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            Pair<Integer, Integer> newKey = new Pair<Integer, Integer>((Integer)location.first, (Integer)location.second);
            if ((Integer)location.first > row) {
                newKey.first = (Integer)location.first - 1;
            }
            Component component = this.locationMap.get(location);
            newMap.put(newKey, component);
        }
        this.rowHeights.remove(row);
        --this.maxRows;
        this.locationMap = newMap;
    }

    private void updateMissingColumn(int column) {
        HashMap<Pair<Integer, Integer>, Component> newMap = new HashMap<Pair<Integer, Integer>, Component>(this.locationMap.size());
        for (Pair<Integer, Integer> location : this.locationMap.keySet()) {
            Pair<Integer, Integer> newKey = new Pair<Integer, Integer>((Integer)location.first, (Integer)location.second);
            if ((Integer)location.second > column) {
                newKey.second = (Integer)location.second - 1;
            }
            Component component = this.locationMap.get(location);
            newMap.put(newKey, component);
        }
        this.columnWidths.remove(column);
        --this.maxColumns;
        this.locationMap = newMap;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public void layoutContainer(Container parent) {
        Object[] components = parent.getComponents();
        if (ArrayUtility.isEmpty(components)) {
            return;
        }
        Dimension parentSize = parent.getSize();
        Insets parentInsets = parent.getInsets();
        Insets borderInsets = this.getBorderInsets(parent);
        int left = parentInsets.left + borderInsets.left;
        int top = parentInsets.top + borderInsets.top;
        int width = parentSize.width - parentInsets.left - parentInsets.right - borderInsets.left - borderInsets.right - (this.maxColumns - 1) * this.dividerSize;
        int height = parentSize.height - parentInsets.top - parentInsets.bottom - borderInsets.top + borderInsets.bottom - (this.maxRows - 1) * this.dividerSize;
        int[] columnWidths = this.getColumnWidths(width);
        int[] rowHeights = this.getRowHeights(height);
        int[] columnOffsets = new int[this.maxColumns];
        int[] rowOffsets = new int[this.maxRows];
        Set<Pair<Integer, Integer>> locations = this.locationMap.keySet();
        for (Pair<Integer, Integer> location : locations) {
            Component component = this.locationMap.get(location);
            if (component == null) continue;
            int row = (Integer)location.first;
            int col = (Integer)location.second;
            if (row >= rowHeights.length || col >= columnWidths.length) {
                System.err.printf("SplitPaneLayout.layoutContainer(parent=%s): location (%d, %d) is not valid for rowHeights=%d. columnWidths=%d\n", parent.getClass().getSimpleName(), location.first, location.second, rowHeights.length, columnWidths.length);
                continue;
            }
            int cellWidth = columnWidths[col];
            int sumWidths = 0;
            int c = 0;
            while (c < col) {
                sumWidths += columnWidths[c];
                ++c;
            }
            int cellHeight = rowHeights[row];
            int sumHeights = 0;
            int r = 0;
            while (r < row) {
                sumHeights += rowHeights[r];
                ++r;
            }
            int x = left + sumWidths + col * this.dividerSize;
            int y = top + sumHeights + row * this.dividerSize;
            columnOffsets[col] = x + cellWidth;
            rowOffsets[row] = y + cellHeight;
            component.setBounds(x, y, cellWidth, cellHeight);
        }
        Object[] objectArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Object component = objectArray[n2];
            if (component instanceof SplitPaneDivider) {
                SplitPaneDivider divider = (SplitPaneDivider)component;
                int order = divider.getOrder();
                int orientation = divider.getOrientation();
                if (orientation == 0) {
                    divider.setBounds(columnOffsets[order], top, this.dividerSize, parentSize.height);
                } else {
                    divider.setBounds(left, rowOffsets[order], parentSize.width, this.dividerSize);
                }
            }
            ++n2;
        }
    }

    private int[] getColumnWidths(int paneWidth) {
        int availableWidth = paneWidth;
        int[] columnWidth = new int[this.maxColumns];
        int zeroColumns = 0;
        int c = 0;
        while (c < this.maxColumns) {
            double pct = this.columnWidths.get(c);
            if (pct == 0.0) {
                ++zeroColumns;
            } else {
                columnWidth[c] = (int)((double)paneWidth * pct);
                availableWidth -= columnWidth[c];
            }
            ++c;
        }
        if (zeroColumns > 0) {
            int remainingCellWidth = availableWidth / zeroColumns;
            int c2 = 0;
            while (c2 < columnWidth.length) {
                if (columnWidth[c2] == 0) {
                    columnWidth[c2] = remainingCellWidth;
                }
                ++c2;
            }
        }
        int totalComputedWidth = 0;
        int c3 = 0;
        while (c3 < columnWidth.length) {
            totalComputedWidth += columnWidth[c3];
            ++c3;
        }
        int widthDifference = paneWidth - totalComputedWidth;
        if (widthDifference > 0) {
            int widthAdjustment = widthDifference / columnWidth.length;
            int c4 = 0;
            while (c4 < columnWidth.length) {
                int n = c4++;
                columnWidth[n] = columnWidth[n] + widthAdjustment;
            }
        }
        return columnWidth;
    }

    private int[] getRowHeights(int paneHeight) {
        int availableHeight = paneHeight;
        int[] rowHeight = new int[this.maxRows];
        int zeroHeights = 0;
        int r = 0;
        while (r < this.maxRows) {
            double pct = this.rowHeights.get(r);
            if (pct == 0.0) {
                ++zeroHeights;
            } else {
                rowHeight[r] = (int)((double)paneHeight * pct);
                availableHeight -= rowHeight[r];
            }
            ++r;
        }
        if (zeroHeights > 0) {
            int remainingCellWidth = availableHeight / zeroHeights;
            int r2 = 0;
            while (r2 < rowHeight.length) {
                if (rowHeight[r2] == 0) {
                    rowHeight[r2] = remainingCellWidth;
                }
                ++r2;
            }
        }
        int totalComputedHeight = 0;
        int r3 = 0;
        while (r3 < rowHeight.length) {
            totalComputedHeight += rowHeight[r3];
            ++r3;
        }
        int heightDifference = paneHeight - totalComputedHeight;
        if (heightDifference > 0) {
            int heightAdjustment = heightDifference / rowHeight.length;
            int r4 = 0;
            while (r4 < rowHeight.length) {
                int n = r4++;
                rowHeight[n] = rowHeight[n] + heightAdjustment;
            }
        }
        return rowHeight;
    }

    private Pair<Integer, Integer> getNextUsableLocation() {
        if (CollectionUtility.isEmpty(this.locationMap)) {
            return new Pair<Integer, Integer>(0, 0);
        }
        ArrayList<Pair<Integer, Integer>> locations = new ArrayList<Pair<Integer, Integer>>(this.locationMap.keySet());
        Collections.sort(locations);
        Pair<Integer, Integer> lastLocation = locations.get(locations.size() - 1);
        int row = (Integer)lastLocation.first;
        int col = (Integer)lastLocation.second;
        if (++col >= this.maxColumns) {
            col = 0;
            ++row;
        }
        Pair<Integer, Integer> nextLocation = new Pair<Integer, Integer>(row, col);
        return nextLocation;
    }
}

