/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.swing.table.OutputStreamTableModelExport;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DelimitedTableModelExport
extends OutputStreamTableModelExport {
    private String delimiter;

    public DelimitedTableModelExport(JTable table, String delimiter) {
        super(table);
        this.setDelimiter(delimiter);
    }

    public DelimitedTableModelExport(TableModel tableModel, String delimiter) {
        super(tableModel);
        this.setDelimiter(delimiter);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public void export() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        PrintStream out = null;
        OutputStream outputStream = this.getOutputStream();
        out = outputStream == null ? System.out : (outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream));
        if (this.exportTitles()) {
            int col = 0;
            while (col < columnCount) {
                out.print(this.getColumnName(col));
                out.print(this.delimiter);
                ++col;
            }
            out.println();
        }
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.print(this.getValueAt(row, col));
                out.print(this.delimiter);
                ++col;
            }
            out.println();
            ++row;
        }
    }
}

