/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.event.BeanRowSorterListener;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public class DynamicBeanRowSorter
extends RowSorter<DynamicBeanTableModel> {
    private DynamicBeanTableModel tableModel;
    private List<RowSorter.SortKey> sortKeys;
    private BeanComparator<DynamicBean> sorter;
    private int lastColumnSorted;
    private SortOrder lastColumnSortedOrder;
    private ArrayList<BeanRowSorterListener> sorterListeners;

    public DynamicBeanRowSorter(DynamicBeanTableModel tableModel) {
        this.setModel(tableModel);
        this.sorter = new BeanComparator();
    }

    public void setModel(DynamicBeanTableModel tableModel) {
        this.tableModel = tableModel;
        if (this.sortKeys != null) {
            this.sortKeys.clear();
        }
    }

    @Override
    public DynamicBeanTableModel getModel() {
        return this.tableModel;
    }

    public void addBeanSorterListener(BeanRowSorterListener sorterListener) {
        if (sorterListener == null) {
            return;
        }
        if (this.sorterListeners == null) {
            this.sorterListeners = new ArrayList();
        }
        this.sorterListeners.add(sorterListener);
    }

    public ArrayList<BeanRowSorterListener> getSorterListeners() {
        return this.sorterListeners;
    }

    public void setSorterListeners(ArrayList<BeanRowSorterListener> sorterListeners) {
        this.sorterListeners = sorterListeners;
    }

    @Override
    public void toggleSortOrder(int column) {
        this.fireBeforeRowsSorted();
        this.sorter.clearCompareProperties();
        Object columnName = this.tableModel.getColumnName(column);
        SortOrder sortOrder = SortOrder.ASCENDING;
        if (column == this.lastColumnSorted) {
            if (this.lastColumnSortedOrder == null) {
                sortOrder = SortOrder.ASCENDING;
            } else if (this.lastColumnSortedOrder.equals((Object)SortOrder.ASCENDING)) {
                columnName = "-" + (String)columnName;
                sortOrder = SortOrder.DESCENDING;
            }
        }
        this.sortKeys.add(0, new RowSorter.SortKey(column, sortOrder));
        this.sorter.addCompareProperty((String)columnName);
        this.tableModel.sortModel(this.sorter);
        this.lastColumnSorted = column;
        this.lastColumnSortedOrder = sortOrder;
        this.fireTableRowsSorted();
    }

    private void fireBeforeRowsSorted() {
        if (CollectionUtility.isEmpty(this.sorterListeners)) {
            return;
        }
        for (BeanRowSorterListener listener : this.sorterListeners) {
            listener.beforeRowsSorted();
        }
    }

    private void fireTableRowsSorted() {
        if (CollectionUtility.isEmpty(this.sorterListeners)) {
            return;
        }
        for (BeanRowSorterListener listener : this.sorterListeners) {
            listener.tableRowsSorted();
        }
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public void setSortKeys(List keys) {
        if (this.sortKeys != null) {
            this.sortKeys.clear();
        }
        this.sortKeys = keys;
        this.fireRowSorterChanged(null);
    }

    @Override
    public List<RowSorter.SortKey> getSortKeys() {
        if (this.sortKeys == null) {
            this.sortKeys = new ArrayList<RowSorter.SortKey>();
        }
        return this.sortKeys;
    }

    @Override
    public int getViewRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public void modelStructureChanged() {
        this.setSortKeys((List)null);
    }

    @Override
    public void allRowsChanged() {
        this.tableModel.sortModel(this.sorter);
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
        this.tableModel.sortModel(this.sorter);
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
        this.tableModel.sortModel(this.sorter);
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }
}

