/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMTextField;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class FileSelectorTableCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private static File lastDirectory;
    private JMButton btnBrowse;
    private JMTextField txtFileName;
    private JFileChooser fileChooser;
    private String file = "";
    private Object fileSelectionCallbackObject;
    private String fileSelectionCallbackMethodName;
    private boolean isOpen;

    public FileSelectorTableCellEditor() {
        this("Choose File...");
    }

    public FileSelectorTableCellEditor(String buttonLabel) {
        super(new JTextField());
        this.setClickCountToStart(1);
        this.btnBrowse = new JMButton(buttonLabel);
        this.txtFileName = new JMTextField();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setMultiSelectionEnabled(true);
    }

    @Override
    public Object getCellEditorValue() {
        return this.file;
    }

    public void setFileSelectionCallback(Object fileSelectionCallbackObject, String fileSelectionCallbackMethodName) {
        this.fileSelectionCallbackObject = fileSelectionCallbackObject;
        this.fileSelectionCallbackMethodName = fileSelectionCallbackMethodName;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.isOpen) {
            return this.btnBrowse;
        }
        this.isOpen = true;
        if (value != null) {
            this.file = value.toString();
        }
        new AsynchMethodInvoker((Object)this, "getFile");
        return this.btnBrowse;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this.btnBrowse;
        }
        String sValue = value.toString();
        if (sValue.length() == 0) {
            return this.btnBrowse;
        }
        File file = new File(sValue);
        if (!file.exists()) {
            return this.btnBrowse;
        }
        this.txtFileName.setText(sValue);
        return this.txtFileName;
    }

    @Reflected
    private void getFile() {
        this.fileChooser.setCurrentDirectory(lastDirectory);
        if (this.fileChooser.showOpenDialog(null) == 0) {
            File[] selectedFiles = this.fileChooser.getSelectedFiles();
            this.file = selectedFiles[0].getAbsolutePath();
            lastDirectory = selectedFiles[0].getParentFile();
            if (selectedFiles.length > 1 && this.fileSelectionCallbackObject != null) {
                int i = 1;
                while (i < selectedFiles.length) {
                    new AsynchMethodInvoker(this.fileSelectionCallbackObject, this.fileSelectionCallbackMethodName, (Object)selectedFiles[i], 100);
                    ++i;
                }
            }
        }
        this.isOpen = false;
        this.fireEditingStopped();
    }
}

