/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MultiLineTableHeaderRenderer
extends JTextArea
implements TableCellRenderer {
    public MultiLineTableHeaderRenderer(JTable table) {
        this.setEditable(false);
        this.setLineWrap(true);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setWrapStyleWord(true);
        Font headerFont = UIManager.getFont("TableHeader.font");
        this.setFont(headerFont.deriveFont(1));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        Color foreground = UIManager.getColor("Table.background");
        Color background = UIManager.getColor("Table.foreground");
        this.setForeground(foreground);
        this.setBackground(background);
        int columnCount = table.getModel().getColumnCount();
        TableColumnModel columnModel = table.getColumnModel();
        int i = 0;
        while (i < columnCount) {
            try {
                TableColumn column = columnModel.getColumn(i);
                column.setHeaderRenderer(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int width = table.getColumnModel().getColumn(column).getWidth();
        this.setText((String)value);
        this.setSize(width, this.getPreferredSize().height);
        return this;
    }
}

