/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMLabel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SimpleBeanTableCellRenderer<BeanType>
extends JMLabel
implements TableCellRenderer {
    private String displayExpression;

    public SimpleBeanTableCellRenderer(String displayExpression) {
        this.displayExpression = displayExpression;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setText("");
            return this;
        }
        if (value instanceof String) {
            this.setText((String)value);
            return this;
        }
        if (this.displayExpression != null) {
            try {
                Object renderValue = BeanService.getPropertyValue(value, this.displayExpression);
                this.setText(String.valueOf(renderValue));
            }
            catch (Exception e) {
                TableColumnModel columnModel = table.getColumnModel();
                TableColumn tableColumn = columnModel.getColumn(column);
                String columnName = String.valueOf(tableColumn.getIdentifier());
                System.err.printf("SimpleBeanTableCellRenderer.getTableCellRendererComponent(table, value=%s, isSelected=%b, hasFocus=%b, row=%d, column=%d): %s in renderer for column %s.\n", value.getClass().getName(), isSelected, hasFocus, row, column, e.getClass().getSimpleName(), columnName);
                this.setText("");
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

