/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor;

import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.text.editor.Lexer;
import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.SyntaxView;
import com.jmorgan.swing.text.editor.actions.SyntaxAction;
import com.jmorgan.swing.text.editor.components.SyntaxComponent;
import com.jmorgan.swing.text.editor.util.Configuration;
import com.jmorgan.swing.text.editor.util.JarServiceProvider;
import com.jmorgan.util.collection.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String CONFIG_CARETCOLOR = "CaretColor";
    public static final String CONFIG_SELECTION = "SelectionColor";
    public static final String CONFIG_COMPONENTS = "Components";
    public static final String CONFIG_MENU = "PopupMenu";
    public static final String CONFIG_TOOLBAR = "Toolbar";
    public static final String CONFIG_TOOLBAR_ROLLOVER = "Toolbar.Buttons.Rollover";
    public static final String CONFIG_TOOLBAR_BORDER = "Toolbar.Buttons.BorderPainted";
    public static final String CONFIG_TOOLBAR_OPAQUE = "Toolbar.Buttons.Opaque";
    public static final String CONFIG_TOOLBAR_BORDER_SIZE = "Toolbar.Buttons.BorderSize";
    private static final Pattern ACTION_KEY_PATTERN;
    private static final Pattern DEFAULT_ACTION_PATTERN;
    private static Font DEFAULT_FONT;
    private static Set<String> CONTENT_TYPES;
    private static Boolean initialized;
    private static Map<String, String> abbreviations;
    private static String MENU_MASK_STRING;
    private final Lexer lexer;
    private static final Logger LOG;
    private final Map<JEditorPane, List<SyntaxComponent>> editorComponents = new WeakHashMap<JEditorPane, List<SyntaxComponent>>();
    private final Map<JEditorPane, JPopupMenu> popupMenu = new WeakHashMap<JEditorPane, JPopupMenu>();
    private static Map<Class<? extends DefaultSyntaxKit>, Configuration> CONFIGS;
    private static final String PLATFORM_KEY;
    private static Properties CONFIGURATION_PROPERTIES;
    private static final String ACTION_MENU_TEXT = "MenuText";

    static {
        int menuMask;
        ACTION_KEY_PATTERN = Pattern.compile("Action\\.((\\w|-)+)");
        DEFAULT_ACTION_PATTERN = Pattern.compile("(DefaultAction.((\\w|-)+)).*");
        CONTENT_TYPES = new HashSet<String>();
        initialized = false;
        MENU_MASK_STRING = "control ";
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        CONFIGURATION_PROPERTIES = new Properties();
        CONFIGURATION_PROPERTIES.put(CONFIG_COMPONENTS, "com.jmorgan.swing.text.editor.components.PairsMarker, com.jmorgan.swing.text.editor.components.LineNumbersRuler");
        CONFIGURATION_PROPERTIES.put("TokenMarker.Color", "0xffeeaa");
        CONFIGURATION_PROPERTIES.put("PairMarker.Color", "0x4b0108");
        CONFIGURATION_PROPERTIES.put("LineNumbers.RightMargin", "7");
        CONFIGURATION_PROPERTIES.put("LineNumbers.Foreground", "0x333300");
        CONFIGURATION_PROPERTIES.put("LineNumbers.Background", "0xeeeeff");
        CONFIGURATION_PROPERTIES.put("LineNumbers.CurrentBack", "0xf07746");
        CONFIGURATION_PROPERTIES.put(CONFIG_CARETCOLOR, "0xffffff");
        CONFIGURATION_PROPERTIES.put("Action.quick-find", "com.jmorgan.swing.text.editor.actions.QuickFindAction, control F");
        CONFIGURATION_PROPERTIES.put("Action.find", "com.jmorgan.swing.text.editor.actions.FindReplaceAction, control H");
        CONFIGURATION_PROPERTIES.put("Action.find.MenuText", "Find");
        CONFIGURATION_PROPERTIES.put("Action.find.ToolTip", "Display Find And Replace Dialog");
        CONFIGURATION_PROPERTIES.put("Action.find-next", "com.jmorgan.swing.text.editor.actions.FindNextAction, F3");
        CONFIGURATION_PROPERTIES.put("Action.find-next.MenuText", "Find Next");
        CONFIGURATION_PROPERTIES.put("Action.find-next.ToolTip", "Repeat Last Find");
        CONFIGURATION_PROPERTIES.put("Action.goto-line", "com.jmorgan.swing.text.editor.actions.GotoLineAction, control G");
        CONFIGURATION_PROPERTIES.put("Action.goto-line.MenuText", "Goto Line Number");
        CONFIGURATION_PROPERTIES.put("Action.goto-line.ToolTip", "Goto Line Number");
        CONFIGURATION_PROPERTIES.put("Action.indent", "com.jmorgan.swing.text.editor.actions.IndentAction, TAB");
        CONFIGURATION_PROPERTIES.put("Action.indent.MenuText", "Indent");
        CONFIGURATION_PROPERTIES.put("Action.indent.Abbreviations", "${class_path}/abbreviations.properties");
        CONFIGURATION_PROPERTIES.put("Action.unindent", "com.jmorgan.swing.text.editor.actions.UnindentAction, shift TAB");
        CONFIGURATION_PROPERTIES.put("Action.unindent.MenuText", "Un-Indent");
        CONFIGURATION_PROPERTIES.put("Action.jindent", "com.jmorgan.swing.text.editor.actions.JIndentAction, ENTER");
        CONFIGURATION_PROPERTIES.put("Action.undo", "com.jmorgan.swing.text.editor.actions.UndoAction, menu Z");
        CONFIGURATION_PROPERTIES.put("Action.undo.MenuText", "Undo");
        CONFIGURATION_PROPERTIES.put("Action.redo", "com.jmorgan.swing.text.editor.actions.RedoAction, menu Y");
        CONFIGURATION_PROPERTIES.put("Action.redo.LinuxKey", "control shift Z");
        CONFIGURATION_PROPERTIES.put("Action.redo.MacKey", "meta shift Z");
        CONFIGURATION_PROPERTIES.put("Action.redo.MenuText", "Redo");
        CONFIGURATION_PROPERTIES.put("Action.delete-lines", "com.jmorgan.swing.text.editor.actions.DeleteLinesAction, control E");
        CONFIGURATION_PROPERTIES.put("Action.delete-lines.MenuText", "Delete Line(s)");
        CONFIGURATION_PROPERTIES.put("Action.dup-lines-up", "com.jmorgan.swing.text.editor.actions.DuplicateLinesAction, shift control UP");
        CONFIGURATION_PROPERTIES.put("Action.dup-lines-up.MenuText", "DUplicate Lines Above");
        CONFIGURATION_PROPERTIES.put("Action.dup-lines-down", "com.jmorgan.swing.text.editor.actions.DuplicateLinesAction, shift control DOWN");
        CONFIGURATION_PROPERTIES.put("Action.dup-lines-down.MenuText", "Duplicate Lines Below");
        CONFIGURATION_PROPERTIES.put("Action.toggle-lines", "com.jmorgan.swing.text.editor.actions.ToggleComponentAction, control F2");
        CONFIGURATION_PROPERTIES.put("Action.toggle-lines.Component", "com.jmorgan.swing.text.editor.components.LineNumbersRuler");
        CONFIGURATION_PROPERTIES.put("Action.toggle-lines.MenuText", "Toggle Line Numbers");
        CONFIGURATION_PROPERTIES.put("Action.toggle-comments", "com.jmorgan.swing.text.editor.actions.ToggleCommentsAction, control SLASH");
        CONFIGURATION_PROPERTIES.put("Action.toggle-comments.MenuText", "Toggle Comments");
        CONFIGURATION_PROPERTIES.put("Action.toggle-comments.SmallIcon", "comment.png");
        CONFIGURATION_PROPERTIES.put("Action.jump-to-pair", "com.jmorgan.swing.text.editor.actions.JumpToPairAction, control OPEN_BRACKET");
        CONFIGURATION_PROPERTIES.put("Action.jump-to-pair.MenuText", "Jump to Pair");
        CONFIGURATION_PROPERTIES.put("Action.complete-word", "com.jmorgan.swing.text.editor.actions.CompleteWordAction, control K");
        CONFIGURATION_PROPERTIES.put("Action.complete-word.MenuText", "Complete Word");
        CONFIGURATION_PROPERTIES.put("Action.smart-home", "com.jmorgan.swing.text.editor.actions.SmartHomeAction, HOME");
        CONFIGURATION_PROPERTIES.put("Action.smart-home-select", "com.jmorgan.swing.text.editor.actions.SmartHomeSelectAction, shift HOME");
        CONFIGURATION_PROPERTIES.put("Action.show-abbs", "com.jmorgan.swing.text.editor.actions.ShowAbbsAction, F8");
        CONFIGURATION_PROPERTIES.put("Action.show-abbs.MenuText", "Show abbreviations");
        CONFIGURATION_PROPERTIES.put("Action.show-abbs.ToolTip", "Show abbreviations");
        CONFIGURATION_PROPERTIES.put("DefaultAction.copy-to-clipboard.MenuText", "Copy");
        CONFIGURATION_PROPERTIES.put("DefaultAction.cut-to-clipboard.MenuText", "Cut");
        CONFIGURATION_PROPERTIES.put("DefaultAction.paste-from-clipboard.MenuText", "Paste");
        CONFIGURATION_PROPERTIES.put("DefaultAction.select-all.MenuText", "Select All");
        CONFIGURATION_PROPERTIES.put("TextAA", "ON");
        CONFIGURATION_PROPERTIES.put("DEFAULT_EDIT_MENU", "cut-to-clipboard     , copy-to-clipboard    , paste-from-clipboard , -                    , select-all           , -                    , undo                 , redo                 , -                    , find                 , find-next            , goto-line            , jump-to-pair         , -                    , complete-word        , show-abbs");
        CONFIGURATION_PROPERTIES.put(CONFIG_MENU, "${DEFAULT_EDIT_MENU} , -                    , goto-line            , toggle-comments");
        CONFIGURATION_PROPERTIES.put("Style.OPERATOR", "0xffff00, 0");
        CONFIGURATION_PROPERTIES.put("Style.DELIMITER", "0xcbcbcb, 0");
        CONFIGURATION_PROPERTIES.put("Style.KEYWORD", "0x569CD6, 0");
        CONFIGURATION_PROPERTIES.put("Style.KEYWORD2", "0x458BC5, 2");
        CONFIGURATION_PROPERTIES.put("Style.TYPE", "0x03a6b3, 0");
        CONFIGURATION_PROPERTIES.put("Style.TYPE2", "0xcbcbcb, 2");
        CONFIGURATION_PROPERTIES.put("Style.TYPE3", "0xcbcbcb, 2");
        CONFIGURATION_PROPERTIES.put("Style.STRING", "0x339933, 2");
        CONFIGURATION_PROPERTIES.put("Style.STRING2", "0x339933, 0");
        CONFIGURATION_PROPERTIES.put("Style.NUMBER", "0x999933, 0");
        CONFIGURATION_PROPERTIES.put("Style.REGEX", "0xcc6600, 0");
        CONFIGURATION_PROPERTIES.put("Style.IDENTIFIER", "0xcbcbcb, 0");
        CONFIGURATION_PROPERTIES.put("Style.COMMENT", "0x949494, 2");
        CONFIGURATION_PROPERTIES.put("Style.COMMENT2", "0x949494, 2");
        CONFIGURATION_PROPERTIES.put("Style.DEFAULT", "0xcbcbcb, 0");
        CONFIGURATION_PROPERTIES.put("Style.WARNING", "0xCC0000, 0");
        CONFIGURATION_PROPERTIES.put("Style.ERROR", "0xCC0000, 2");
        if (!initialized.booleanValue()) {
            DefaultSyntaxKit.initKit();
        }
        if (((menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) & 0x208) != 0) {
            MENU_MASK_STRING = "alt ";
        } else if ((menuMask & 0x104) != 0) {
            MENU_MASK_STRING = "meta ";
        }
        String osName = System.getProperty("os.name");
        PLATFORM_KEY = osName.contains("Linux") ? ".LinuxKey" : (osName.contains("Mac") ? ".MacKey" : ".WindowsKey");
    }

    public static Properties getConfigProperties() {
        return CONFIGURATION_PROPERTIES;
    }

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public void addComponents(JEditorPane editorPane) {
        String[] components;
        String[] stringArray = components = this.getConfig().getPropertyList(CONFIG_COMPONENTS);
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.installComponent(editorPane, c);
            ++n2;
        }
    }

    public void installComponent(JEditorPane pane, String className) {
        try {
            Class<?> compClass = Class.forName(className);
            SyntaxComponent comp = (SyntaxComponent)compClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            comp.config(this.getConfig());
            comp.install(pane);
            if (this.editorComponents.get(pane) == null) {
                this.editorComponents.put(pane, new ArrayList());
            }
            this.editorComponents.get(pane).add(comp);
        }
        catch (InstantiationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deinstallComponent(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            c.deinstall(pane);
            this.editorComponents.get(pane).remove(c);
            break;
        }
    }

    public boolean isComponentInstalled(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean toggleComponent(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            c.deinstall(pane);
            this.editorComponents.get(pane).remove(c);
            return false;
        }
        this.installComponent(pane, className);
        return true;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
    }

    public void addPopupMenu(JEditorPane editorPane) {
        String[] menuItems = this.getConfig().getPropertyList(CONFIG_MENU);
        if (menuItems == null || menuItems.length == 0) {
            return;
        }
        this.popupMenu.put(editorPane, new JPopupMenu());
        Component stack = null;
        String[] stringArray = menuItems;
        int n = menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            String menuString = stringArray[n2];
            if (menuString.equals("-")) {
                this.popupMenu.get(editorPane).addSeparator();
            } else if (menuString.startsWith(">")) {
                JMenu sub = new JMenu(menuString.substring(1));
                this.popupMenu.get(editorPane).add(sub);
                stack = sub;
            } else if (menuString.startsWith("<")) {
                Container parent;
                Container container = parent = stack == null ? null : stack.getParent();
                stack = parent instanceof JMenu ? (JMenu)parent : null;
            } else {
                Action action = editorPane.getActionMap().get(menuString);
                if (action != null) {
                    JMenuItem menuItem = action.getValue("SwingSelectedKey") != null ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
                    if (action.getValue(ACTION_MENU_TEXT) != null) {
                        menuItem.setText((String)action.getValue(ACTION_MENU_TEXT));
                    }
                    if (stack == null) {
                        this.popupMenu.get(editorPane).add(menuItem);
                    } else {
                        ((JMenu)stack).add(menuItem);
                    }
                }
            }
            ++n2;
        }
        editorPane.setComponentPopupMenu(this.popupMenu.get(editorPane));
    }

    public void addToolBarActions(JEditorPane editorPane, JToolBar toolbar) {
        String[] toolBarItems = this.getConfig().getPropertyList(CONFIG_TOOLBAR);
        if (!(toolBarItems != null && toolBarItems.length != 0 || (toolBarItems = this.getConfig().getPropertyList(CONFIG_MENU)) != null && toolBarItems.length != 0)) {
            return;
        }
        boolean btnRolloverEnabled = this.getConfig().getBoolean(CONFIG_TOOLBAR_ROLLOVER, true);
        boolean btnBorderPainted = this.getConfig().getBoolean(CONFIG_TOOLBAR_BORDER, false);
        boolean btnOpaque = this.getConfig().getBoolean(CONFIG_TOOLBAR_OPAQUE, false);
        int btnBorderSize = this.getConfig().getInteger(CONFIG_TOOLBAR_BORDER_SIZE, 2);
        String[] stringArray = toolBarItems;
        int n = toolBarItems.length;
        int n2 = 0;
        while (n2 < n) {
            String menuString = stringArray[n2];
            if (menuString.equals("-") || menuString.startsWith("<") || menuString.startsWith(">")) {
                toolbar.addSeparator();
            } else {
                Action action = editorPane.getActionMap().get(menuString);
                if (action != null && action.getValue("SmallIcon") != null) {
                    JButton b = toolbar.add(action);
                    b.setRolloverEnabled(btnRolloverEnabled);
                    b.setBorderPainted(btnBorderPainted);
                    b.setOpaque(btnOpaque);
                    b.setFocusable(false);
                    b.setBorder(BorderFactory.createEmptyBorder(btnBorderSize, btnBorderSize, btnBorderSize, btnBorderSize));
                }
            }
            ++n2;
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new SyntaxView(element, this.getConfig());
    }

    @Override
    public void install(JEditorPane editorPane) {
        super.install(editorPane);
        if (DEFAULT_FONT == null) {
            System.out.printf("DefaultSyntaxKit.install(editorPane):  DEFAULT FONT IS NULL\n", new Object[0]);
            DEFAULT_FONT = DefaultSyntaxKit.getDefaultFont();
        }
        editorPane.setFont(DEFAULT_FONT);
        Color caretColor = Color.white;
        editorPane.setCaretColor(caretColor);
        Color selectionColor = this.getConfig().getColor(CONFIG_SELECTION, new Color(0x444444));
        editorPane.setSelectionColor(selectionColor);
        this.addActions(editorPane);
        this.addComponents(editorPane);
        this.addPopupMenu(editorPane);
    }

    @Override
    public void deinstall(JEditorPane editorPane) {
        for (SyntaxComponent c : this.editorComponents.get(editorPane)) {
            c.deinstall(editorPane);
        }
        this.editorComponents.clear();
        editorPane.getInputMap().clear();
        ActionMap actionMap = editorPane.getActionMap();
        Object[] objectArray = actionMap.keys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Action a = actionMap.get(key);
            if (a instanceof SyntaxAction) {
                ((SyntaxAction)a).deinstall(editorPane);
            }
            ++n2;
        }
        actionMap.clear();
    }

    public void addActions(JEditorPane editorPane) {
        InputMap imap = new InputMap();
        imap.setParent(editorPane.getInputMap());
        ActionMap amap = new ActionMap();
        amap.setParent(editorPane.getActionMap());
        for (Configuration.StringKeyMatcher m : this.getConfig().getKeys(ACTION_KEY_PATTERN)) {
            String[] values = Configuration.COMMA_SEPARATOR.split(m.value);
            String actionClass = values[0];
            String actionName = m.group1;
            SyntaxAction action = this.createAction(actionClass);
            action.install(editorPane, this.getConfig(), "Action." + actionName);
            amap.put(actionName, action);
            String platformKey = this.getProperty(m.key + PLATFORM_KEY);
            int i = 1;
            while (i < values.length) {
                String ksString = values[i].replace("menu ", MENU_MASK_STRING);
                String keyStrokeString = platformKey == null ? ksString : platformKey;
                KeyStroke ks = KeyStroke.getKeyStroke(keyStrokeString);
                if (ks == null) {
                    throw new IllegalArgumentException("Invalid KeyStroke: " + keyStrokeString);
                }
                action.putValue("AcceleratorKey", ks);
                imap.put(ks, actionName);
                ++i;
            }
        }
        for (Configuration.StringKeyMatcher m : this.getConfig().getKeys(DEFAULT_ACTION_PATTERN)) {
            String name = m.matcher.group(2);
            Action action = editorPane.getActionMap().get(name);
            if (action == null) continue;
            this.configActionProperties(action, name, m.group1);
        }
        editorPane.setActionMap(amap);
        editorPane.setInputMap(0, imap);
    }

    private void configActionProperties(Action action, String actionName, String configKey) {
        String iconLoc = this.getConfig().getString(configKey + ".SmallIcon", actionName + ".png");
        URL loc = this.getClass().getClassLoader().getResource("com.jmorgan.swing.text.editor/images/small-icons/" + iconLoc);
        if (loc != null) {
            ImageIcon i = new ImageIcon(loc);
            action.putValue("SmallIcon", i);
        }
        String name = this.getProperty(configKey + ".MenuText");
        if (action.getValue("Name") == null) {
            action.putValue("Name", name);
        } else {
            action.putValue(ACTION_MENU_TEXT, name);
        }
        String shortDesc = this.getProperty(configKey + ".ToolTip");
        if (shortDesc != null) {
            action.putValue("ShortDescription", shortDesc);
        } else {
            action.putValue("ShortDescription", name);
        }
    }

    private SyntaxAction createAction(String actionClassName) {
        SyntaxAction action;
        try {
            Class<?> type = Class.forName(actionClassName);
            action = (SyntaxAction)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName + ". Ensure it has default constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, e);
        }
        return action;
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static synchronized void initKit() {
        if (initialized.booleanValue()) {
            return;
        }
        String defaultFont = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class).getString("DefaultFont");
        if (defaultFont != null) {
            Font font = Font.decode(defaultFont);
            DEFAULT_FONT = font.deriveFont(1);
        } else {
            DEFAULT_FONT = DefaultSyntaxKit.getDefaultFont();
        }
        Properties kitsForTypes = JarServiceProvider.readProperties("com.jmorgan.swing.text.editor/kitsfortypes");
        for (Map.Entry<Object, Object> e : kitsForTypes.entrySet()) {
            String type = e.getKey().toString();
            String className = e.getValue().toString();
            DefaultSyntaxKit.registerContentType(type, className);
        }
        initialized = true;
    }

    public static Font getDefaultFont() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        Set<String> fontSet = Sets.toSet(fonts);
        Font font = null;
        font = fontSet.contains("Monospaced") ? new Font("Monospaced", 1, 13) : (fontSet.contains("DialogInput") ? new Font("DialogInput", 1, 12) : (fontSet.contains("Courier New") ? new Font("Courier New", 1, 12) : new Font("DialogInput", 1, 12)));
        return font;
    }

    public static void registerContentType(String type, String className) {
        try {
            Class<?> c = Class.forName(className);
            Object kit = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(kit instanceof EditorKit)) {
                throw new IllegalArgumentException("Cannot register class: " + className + ". It does not extend EditorKit");
            }
            JEditorPane.registerEditorKitForContentType(type, className);
            CONTENT_TYPES.add(type);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className + ". Ensure it has Default Constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
    }

    public static String[] getContentTypes() {
        Object[] types = CONTENT_TYPES.toArray(new String[0]);
        Arrays.sort(types);
        return types;
    }

    public void setConfig(Properties config) {
        this.getConfig().putAll((Map)config);
    }

    public void setProperty(String key, String value) {
        this.getConfig().put(key, value);
    }

    public String getProperty(String key) {
        return this.getConfig().getString(key);
    }

    public Configuration getConfig() {
        return DefaultSyntaxKit.getConfig(this.getClass());
    }

    public static synchronized Configuration getConfig(Class<? extends DefaultSyntaxKit> kit) {
        if (CONFIGS == null) {
            CONFIGS = new WeakHashMap<Class<? extends DefaultSyntaxKit>, Configuration>();
            Configuration defaultConfig = new Configuration(DefaultSyntaxKit.class);
            DefaultSyntaxKit.loadConfig(defaultConfig, DefaultSyntaxKit.class);
            CONFIGS.put(DefaultSyntaxKit.class, defaultConfig);
        }
        if (CONFIGS.containsKey(kit)) {
            return CONFIGS.get(kit);
        }
        Class<? extends DefaultSyntaxKit> superKit = kit.getSuperclass();
        Configuration defaults = DefaultSyntaxKit.getConfig(superKit);
        Configuration mine = new Configuration(kit, defaults);
        DefaultSyntaxKit.loadConfig(mine, kit);
        CONFIGS.put(kit, mine);
        return mine;
    }

    public Map<String, String> getAbbreviations() {
        if (abbreviations == null) {
            String cl = this.getClass().getName().replace('.', '/').toLowerCase();
            abbreviations = JarServiceProvider.readStringsMap(cl + "/abbreviations.properties");
        }
        return abbreviations;
    }

    public static void addAbbreviation(String abbr, String template) {
        if (abbreviations == null) {
            abbreviations = new HashMap<String, String>();
        }
        abbreviations.put(abbr, template);
    }

    public static String getAbbreviation(String abbr) {
        return abbreviations == null ? null : abbreviations.get(abbr);
    }

    private static void loadConfig(Configuration conf, Class<? extends EditorKit> kit) {
        MethodInvoker mi = new MethodInvoker(kit, "getConfigProperties", new Object[0]);
        Properties p = (Properties)mi.invoke();
        conf.putAll((Map)p);
    }

    @Override
    public String getContentType() {
        return "text/" + this.getClass().getSimpleName().replace("SyntaxKit", "").toLowerCase();
    }
}

