/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ScriptRunnerAction
extends DefaultSyntaxAction {
    static ScriptEngineManager sem;
    private ScriptEngine engine;
    private String scriptExtension;

    public ScriptRunnerAction() {
        super("SCRIPT_EXECUTE");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        try {
            ScriptEngine eng = this.getEngine(target);
            if (eng != null) {
                this.getEngine(target).eval(target.getText());
            }
        }
        catch (ScriptException ex) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(target), ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptRunnerAction.ErrorExecutingScript") + ex.getMessage(), ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptRunnerAction.ScriptError"), 0);
            ActionUtils.setCaretPosition(target, ex.getLineNumber(), ex.getColumnNumber());
        }
    }

    private ScriptEngine getEngine(JTextComponent target) {
        int result;
        if (this.engine == null) {
            if (sem == null) {
                sem = new ScriptEngineManager();
            }
            this.engine = sem.getEngineByExtension(this.scriptExtension);
        }
        if (this.engine == null && (result = JOptionPane.showOptionDialog(target, MessageFormat.format(ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptRunnerAction.ScriptEngineNotFound"), this.scriptExtension), "com.jmorgan.swing.text.editor", 0, 0, null, null, null)) == 0) {
            this.setEnabled(false);
        }
        return this.engine;
    }

    public void setScriptExtension(String value) {
        this.scriptExtension = value;
    }
}

