/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import com.jmorgan.swing.text.editor.SyntaxView;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.lang.reflect.Member;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;

abstract class MemberCell
extends JPanel {
    private final JList list;
    private final boolean isSelected;
    private final Color backColor;
    private final Member member;
    private final Class theClass;

    public MemberCell(JList list, boolean isSelected, Color backColor, Member member, Class clazz) {
        this.list = list;
        this.isSelected = isSelected;
        this.backColor = backColor;
        this.member = member;
        this.theClass = clazz;
    }

    @Override
    public void paintComponent(Graphics g) {
        SyntaxView.setRenderingHits((Graphics2D)g);
        g.setFont(this.list.getFont());
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.isSelected ? this.list.getSelectionBackground() : this.backColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.isSelected ? this.list.getSelectionForeground() : this.list.getForeground());
        Image icn = this.getIcon();
        g.drawImage(icn, 2, 0, null);
        int x = 6 + (icn == null ? 0 : icn.getWidth(this));
        int y = fm.getHeight();
        if (this.member.getDeclaringClass().equals(this.theClass)) {
            Font bold = this.list.getFont().deriveFont(1);
            g.setFont(bold);
        }
        x = this.drawString(this.getMemberName(), x, y, g);
        g.setFont(this.list.getFont());
        x = this.drawString(this.getArguments(), x, y, g);
        String right = this.getReturnType();
        int rw = fm.stringWidth(right);
        g.drawString(right, this.getWidth() - rw - 4, fm.getAscent());
    }

    @Override
    public Dimension getPreferredSize() {
        Font font = this.list.getFont();
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        String total = this.getMemberName() + this.getArguments() + this.getReturnType() + "  ";
        return new Dimension(fm.stringWidth(total) + 20, Math.max(fm.getHeight(), 16));
    }

    private int drawString(String string, int x, int y, Graphics g) {
        if (ActionUtils.isEmptyOrBlanks(string)) {
            return x;
        }
        int w = g.getFontMetrics().stringWidth(string);
        g.drawString(string, x, y);
        return x + w;
    }

    Map<Integer, Image> readIcons(String loc) {
        HashMap<Integer, Image> icons = new HashMap<Integer, Image>();
        icons.put(1, this.readImage(loc, ""));
        icons.put(2, this.readImage(loc, "_private"));
        icons.put(4, this.readImage(loc, "_protected"));
        icons.put(9, this.readImage(loc, "_static"));
        icons.put(10, this.readImage(loc, "_static_private"));
        icons.put(12, this.readImage(loc, "_static_protected"));
        return icons;
    }

    private Image readImage(String iconLoc, String kind) {
        String fullPath = iconLoc + kind + ".png";
        URL loc = this.getClass().getClassLoader().getResource(fullPath);
        if (loc == null) {
            return null;
        }
        return new ImageIcon(loc).getImage();
    }

    protected String getMemberName() {
        return this.member.getName();
    }

    protected abstract String getArguments();

    protected abstract String getReturnType();

    protected abstract Image getIcon();
}

