/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectUtils {
    public static final List<String> DEFAULT_PACKAGES = new ArrayList<String>(3);
    private static HashMap<String, Method> SETTERS_MAP;

    static {
        DEFAULT_PACKAGES.add("java.lang");
        DEFAULT_PACKAGES.add("java.util");
        DEFAULT_PACKAGES.add("com.jmorgan.swing.text.editor");
        SETTERS_MAP = new HashMap();
    }

    public static int addMethods(Class aClass, List<Member> list) {
        Method[] methods;
        Method[] methodArray = methods = aClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            list.add(m);
            ++n2;
        }
        return methods.length;
    }

    public static int addStaticMethods(Class aClass, List<Member> list) {
        Method[] methods;
        Method[] methodArray = methods = aClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers())) {
                list.add(m);
            }
            ++n2;
        }
        return methods.length;
    }

    public static int addStaticFields(Class aClass, List<Member> list) {
        Field[] fields;
        Field[] fieldArray = fields = aClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (Modifier.isStatic(f.getModifiers())) {
                list.add(f);
            }
            ++n2;
        }
        return fields.length;
    }

    public static int addFields(Class aClass, List<Member> list) {
        Field[] fields;
        Field[] fieldArray = fields = aClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            list.add(f);
            ++n2;
        }
        return fields.length;
    }

    public static int addConstrcutors(Class aClass, List<Member> list) {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = aClass.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            list.add(c);
            ++n2;
        }
        return constructors.length;
    }

    public static String getJavaCallString(Constructor c) {
        StringBuilder call = new StringBuilder();
        call.append(c.getDeclaringClass().getSimpleName());
        ReflectUtils.addParamsString(call, c.getParameterTypes());
        return call.toString();
    }

    public static String getJavaCallString(Method method) {
        StringBuilder call = new StringBuilder();
        call.append(method.getName());
        ReflectUtils.addParamsString(call, method.getParameterTypes());
        return call.toString();
    }

    public static StringBuilder addParamsString(StringBuilder call, Class[] params) {
        call.append("(");
        boolean firstArg = true;
        Class[] classArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Class arg = classArray[n2];
            if (firstArg) {
                firstArg = false;
            } else {
                call.append(", ");
            }
            call.append(arg.getSimpleName());
            ++n2;
        }
        call.append(")");
        return call;
    }

    public static String[] getMethodCalls(Class aClass) {
        String[] methods = new String[aClass.getMethods().length];
        int i = 0;
        Method[] methodArray = aClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            methods[i++] = ReflectUtils.getJavaCallString(method);
            ++n2;
        }
        return methods;
    }

    public static String[] getConstructorCalls(Class aClass) {
        Constructor<?>[] constructors = aClass.getConstructors();
        String[] cons = new String[constructors.length];
        int i = 0;
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            cons[i++] = ReflectUtils.getJavaCallString(c);
            ++n2;
        }
        return cons;
    }

    public static String getParamsString(Class[] params) {
        StringBuilder sb = new StringBuilder();
        ReflectUtils.addParamsString(sb, params);
        return sb.toString();
    }

    public static Class findClass(String className, List<String> packages) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (String pack : packages) {
            try {
                return Class.forName(pack + "." + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean callSetter(Object obj, String property, Object value) {
        String key = String.format("%s.%s(%s)", obj.getClass().getName(), property, value.getClass().getName());
        Method m = null;
        boolean result = false;
        if (!SETTERS_MAP.containsKey(key)) {
            m = ReflectUtils.findMethod(obj, property, value);
            SETTERS_MAP.put(key, m);
        } else {
            m = SETTERS_MAP.get(key);
        }
        if (m != null) {
            try {
                m.invoke(obj, value);
                result = true;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized Method findMethod(Object obj, String property, Object value) {
        m = null;
        theClass = obj.getClass();
        setter = String.format("set%C%s", new Object[]{Character.valueOf(property.charAt(0)), property.substring(1)});
        paramType = value.getClass();
        while (paramType != null) {
            try {
                m = theClass.getMethod(setter, new Class[]{paramType});
                return m;
            }
            catch (NoSuchMethodException ex) {
                var11_11 = paramType.getInterfaces();
                var10_10 = var11_11.length;
                var9_9 = 0;
                ** while (var9_9 < var10_10)
            }
lbl-1000:
            // 1 sources

            {
                iface = var11_11[var9_9];
                try {
                    m = theClass.getMethod(setter, new Class[]{iface});
                    return m;
                }
                catch (NoSuchMethodException var12_12) {
                    ++var9_9;
                }
                continue;
            }
lbl21:
            // 1 sources

            paramType = paramType.getSuperclass();
        }
        return m;
    }
}

