/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.style.BorderStyle;
import com.jmorgan.swing.style.ColorStyle;
import com.jmorgan.swing.style.GUIStyle;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.util.Index;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;

public abstract class AbstractComponentStyleController {
    private Index<String, GUIStyle> styles = new Index();
    private ArrayList<Component> components = new ArrayList();

    public AbstractComponentStyleController() {
    }

    public AbstractComponentStyleController(Component ... components) {
        this();
        this.components.addAll(Arrays.asList(components));
    }

    public void addStyle(String name, GUIStyle style) {
        if (name == null || style == null) {
            return;
        }
        this.styles.put(name, style);
    }

    public void removeStyle(String name, GUIStyle style) {
        ArrayList styles = (ArrayList)this.styles.get(name);
        if (styles == null) {
            return;
        }
        styles.remove(style);
    }

    public Index<String, GUIStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(Index<String, GUIStyle> styles) {
        this.styles = styles;
    }

    public void addComponents(Component ... components) {
        if (components == null) {
            return;
        }
        this.components.addAll(Arrays.asList(components));
    }

    public ArrayList<Component> getComponents() {
        return this.components;
    }

    public void setComponents(ArrayList<Component> components) {
        this.components = components;
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
    }

    protected void applyStyles(String name) {
        if (name == null || this.components == null) {
            return;
        }
        for (Component component : this.components) {
            this.applyStyles(name, component);
        }
    }

    protected void applyStyles(String name, Component component) {
        if (name == null || component == null) {
            return;
        }
        Collection<GUIStyle> styles = this.styles.get(name);
        if (styles == null) {
            return;
        }
        for (GUIStyle style : styles) {
            if (style instanceof ColorStyle) {
                ColorStyle colorStyle = (ColorStyle)style;
                component.setBackground(colorStyle.getBackground());
                if (BeanService.hasProperty(component, "color")) {
                    BeanService.setPropertyValue(component, "color", colorStyle.getForeground());
                }
            }
            if (style instanceof BorderStyle && component instanceof JComponent) {
                JComponent jcomponent = (JComponent)component;
                BorderStyle borderStyle = (BorderStyle)style;
                jcomponent.setBorder(borderStyle.getBorder());
            }
            if (!(style instanceof TextStyle) || !BeanService.hasProperty(component, "font")) continue;
            TextStyle textStyle = (TextStyle)style;
            Font font = textStyle.getFont();
            BeanService.setPropertyValue(component, "font", font);
        }
    }
}

