/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.io.filefilter.FileFilterAdapter;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.GUIApplicationProperties;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.ExceptionDialog;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.JMImageIcon;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.ToolBarButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class GUIServices {
    private static String lastKnownDirectory;
    private static final boolean TYPE_FILE_OPEN = true;
    private static final boolean TYPE_FILE_SAVE = false;

    private GUIServices() {
    }

    public static Container getContentPane(Container requestor) {
        Container contentPane = null;
        contentPane = requestor instanceof JFrame || requestor instanceof JInternalFrame || requestor instanceof JDialog || requestor instanceof JWindow ? ((RootPaneContainer)((Object)requestor)).getContentPane() : requestor;
        return contentPane;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Point getCenterOf(Dimension dimension) {
        double width = dimension.getWidth();
        double height = dimension.getHeight();
        Point center = new Point((int)(width / 2.0), (int)(height / 2.0));
        return center;
    }

    public static Point getCenterOf(Rectangle rectangle) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        Point center = new Point((int)(x + width / 2.0), (int)(y + height / 2.0));
        return center;
    }

    public static Point2D getCenterOf(Rectangle2D rectangle) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        Point center = new Point((int)(x + width / 2.0), (int)(y + height / 2.0));
        return center;
    }

    public static void centerOnWindow(Window referenceWindow, Window windowToCenter) {
        Dimension referenceSize = referenceWindow.getSize();
        Point referenceLocation = referenceWindow.getLocation();
        Point referenceMiddle = new Point(referenceLocation.x + referenceSize.width / 2, referenceLocation.y + referenceSize.height / 2);
        Dimension centeringSize = windowToCenter.getSize();
        Point centeringLocation = new Point(referenceMiddle.x - centeringSize.width / 2, referenceMiddle.y - centeringSize.height / 2);
        windowToCenter.setLocation(centeringLocation);
    }

    public static void centerWindow(Window w) {
        Dimension d = GUIServices.getScreenSize();
        w.setLocation(d.width / 2 - w.getWidth() / 2, d.height / 2 - w.getHeight() / 2);
    }

    public static void maximizeWindow(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            frame.setExtendedState(frame.getExtendedState() | 6);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle maxWindowBounds = ge.getMaximumWindowBounds();
            window.setLocation(maxWindowBounds.x, maxWindowBounds.y);
            window.setSize(maxWindowBounds.width, maxWindowBounds.height);
        }
    }

    public static void maximizeWindowOver(Window windowToMaximize, Window windowToMaximizerOver) {
        if (windowToMaximize == null || windowToMaximizerOver == null) {
            return;
        }
        Rectangle maxWindowOverBounds = windowToMaximizerOver.getBounds();
        windowToMaximize.setLocation(maxWindowOverBounds.x, maxWindowOverBounds.y);
        windowToMaximize.setSize(maxWindowOverBounds.width, maxWindowOverBounds.height);
    }

    public static GraphicsDevice getGraphicsDevice(Component component) {
        GraphicsDevice device = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = graphicsEnvironment.getScreenDevices();
        ArrayList<GraphicsDevice> screenList = new ArrayList<GraphicsDevice>(screens.length);
        if (component != null && component.isVisible()) {
            GraphicsConfiguration gc;
            Rectangle parentBounds = component.getBounds();
            if (!(component instanceof Window)) {
                Point p = new Point(0, 0);
                SwingUtilities.convertPointToScreen(p, component);
                parentBounds.setLocation(p);
            }
            GraphicsDevice[] graphicsDeviceArray = screens;
            int n = screens.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice screen = graphicsDeviceArray[n2];
                gc = screen.getDefaultConfiguration();
                Rectangle screenBounds = gc.getBounds();
                if (screenBounds.intersects(parentBounds)) {
                    screenList.add(screen);
                }
                ++n2;
            }
            if (screenList.size() == 1) {
                device = (GraphicsDevice)screenList.get(0);
            } else if (screenList.size() > 1) {
                GraphicsDevice gdMost = null;
                float maxArea = 0.0f;
                for (GraphicsDevice screen : screenList) {
                    gc = screen.getDefaultConfiguration();
                    Rectangle bounds = gc.getBounds();
                    Rectangle2D intBounds = bounds.createIntersection(parentBounds);
                    float perArea = (float)(intBounds.getWidth() * intBounds.getHeight() / (double)(parentBounds.width * parentBounds.height));
                    if (!(perArea > maxArea)) continue;
                    maxArea = perArea;
                    gdMost = screen;
                }
                if (gdMost != null) {
                    device = gdMost;
                }
            }
        }
        return device;
    }

    public static void moveToScreen(Window window, int screen) {
        if (window == null) {
            throw new NullPointerException("The window reference cannot be null.");
        }
        if (screen < 0) {
            throw new IndexOutOfBoundsException(String.format("The screen parameter of %d cannot be less than 0.", screen));
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = ge.getScreenDevices();
        if (screen >= graphicsDevices.length) {
            throw new IndexOutOfBoundsException(String.format("The screen parameter of %d is must be less than the number of graphics devices present, which is %d.", screen, graphicsDevices.length));
        }
        GraphicsConfiguration graphicsConfig = graphicsDevices[screen].getDefaultConfiguration();
        JFrame positioner = new JFrame(graphicsConfig);
        window.setLocationRelativeTo(positioner);
        positioner.dispose();
    }

    public static int getScreenCount() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = ge.getScreenDevices();
        return graphicsDevices.length;
    }

    public static Container getParentByName(Component component, String name) {
        Container c = component.getParent();
        while (c != null) {
            String cName = c.getName();
            if (cName != null && cName.equalsIgnoreCase(name)) {
                return c;
            }
            c = c.getParent();
        }
        return c;
    }

    public static <T extends Container> T getParentByType(Component component, Class<T> type) {
        Container c = component.getParent();
        while (c != null) {
            if (type.isInstance(c)) break;
            c = c.getParent();
        }
        return (T)c;
    }

    public static Window getParentWindow(Component component) {
        Container c = component.getParent();
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    public static JFrame getFrame(Component component) {
        Container c = component.getParent();
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        return (JFrame)c;
    }

    public static Component getFocusedComponent(Container container) {
        Collection<Component> components = GUIServices.getAllComponents(container);
        for (Component c : components) {
            if (!c.hasFocus()) continue;
            return c;
        }
        return null;
    }

    public static Collection<Component> getAllComponents(Container container) {
        Component[] comps;
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(container);
        Component[] componentArray = comps = container.getComponents();
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof Container) {
                components.addAll(GUIServices.getAllComponents((Container)comp));
            } else {
                components.add(comp);
            }
            ++n2;
        }
        return components;
    }

    public static <InterfaceType> Collection<InterfaceType> findImplementingComponents(Container parent, Class<InterfaceType> interFace) {
        Component[] children;
        Component[] componentArray;
        ArrayList<Object> components = new ArrayList<Object>();
        if (parent instanceof JMenu) {
            JMenu menu = (JMenu)parent;
            componentArray = menu.getMenuComponents();
        } else {
            componentArray = parent.getComponents();
        }
        Component[] componentArray2 = children = componentArray;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray2[n2];
            if (child instanceof Container) {
                Container container = (Container)child;
                components.addAll(GUIServices.findImplementingComponents(container, interFace));
            }
            if (child.getClass().isInstance(interFace)) {
                components.add(child);
            }
            if (child.getClass().equals(interFace)) {
                components.add(child);
            }
            ++n2;
        }
        if (parent.getClass().isInstance(interFace)) {
            components.add(parent);
        }
        return components;
    }

    public static void addListenerToAll(Component component, EventListener listener, String listenerClassType) {
        GUIServices.handleAddRemoveListener(component, listener, listenerClassType, true);
    }

    public static void removeListenerFromAll(Component component, EventListener listener, String listenerClassType) {
        GUIServices.handleAddRemoveListener(component, listener, listenerClassType, false);
    }

    private static void handleAddRemoveListener(Component component, EventListener listener, String listenerClassType, boolean add) {
        String methodName = (add ? "add" : "remove") + listenerClassType;
        new MethodInvoker((Object)component, methodName, listener);
        if (component instanceof Container) {
            Component[] nestedComps;
            Container container = (Container)component;
            Component[] componentArray = nestedComps = container.getComponents();
            int n = nestedComps.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                GUIServices.handleAddRemoveListener(c, listener, listenerClassType, add);
                ++n2;
            }
        }
    }

    public static String getArtRootBaseDirectory() {
        GUIApplication guiApplication = GUIApplication.getGUIApplication();
        File artRoot = null;
        if (guiApplication != null) {
            GUIApplicationProperties guiAppProps = (GUIApplicationProperties)((Object)GUIApplication.getGUIApplication().getApplicationProperties());
            artRoot = guiAppProps.getArtRoot();
        } else {
            artRoot = new File("/resources/");
        }
        String artRootName = String.format("/%s/", artRoot.getName());
        return artRootName;
    }

    public static Rectangle2D getFontDisplaySize(String stringToRender, String uiManagerFontKey) {
        Font textFont = UIManager.getFont(uiManagerFontKey);
        if (textFont == null) {
            throw new RuntimeException(String.format("UIManager cannot find a font for %s", uiManagerFontKey));
        }
        return GUIServices.getFontDisplaySize(stringToRender, textFont);
    }

    public static Rectangle2D getFontDisplaySize(String stringToRender, Font font) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D fontSize = font.getStringBounds(stringToRender, frc);
        return fontSize;
    }

    public static File fileOpenDialog(String currentDirectory) {
        return GUIServices.fileOpenDialog(currentDirectory, null);
    }

    public static File fileOpenDialog(String currentDirectory, FileFilterAdapter filter) {
        return GUIServices.fileDialog(currentDirectory, filter, true);
    }

    public static File fileSaveDialog(String currentDirectory) {
        return GUIServices.fileSaveDialog(currentDirectory, null);
    }

    public static File fileSaveDialog(String currentDirectory, FileFilterAdapter filter) {
        return GUIServices.fileDialog(currentDirectory, filter, false);
    }

    private static File fileDialog(String currentDirectory, FileFilterAdapter filter, boolean type) {
        block4: {
            File file;
            Window cwfw;
            block5: {
                int userOption;
                Component cwf = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                cwfw = cwf == null ? null : GUIServices.getParentWindow(cwf);
                String startDir = currentDirectory != null ? currentDirectory : lastKnownDirectory;
                JFileChooser fod = new JFileChooser(startDir);
                fod.setFileSelectionMode(2);
                if (filter != null) {
                    fod.setFileFilter(filter);
                }
                int n = userOption = type ? fod.showOpenDialog(cwfw) : fod.showSaveDialog(cwfw);
                if (userOption != 0) break block4;
                file = fod.getSelectedFile();
                lastKnownDirectory = file.getAbsolutePath();
                if (type || !file.exists()) break block5;
                new JMMessageBox(null, "Confirm Replace", String.valueOf(file) + " exists.  Overwrite?", 14);
                if (JMMessageBox.getSelection() != 8 && JMMessageBox.getSelection() != 2) break block5;
                return null;
            }
            try {
                return file;
            }
            catch (HeadlessException e) {
                new ExceptionDialog(cwfw, "File " + (type ? "Open" : "Save") + " Dialog Error", "Error Getting File to " + (type ? "Open" : "Save"), e);
            }
        }
        return null;
    }

    public static File[] getFilesDialog(String startDirectory) {
        File[] files = null;
        if (startDirectory == null) {
            startDirectory = lastKnownDirectory;
        }
        JFileChooser fc = new JFileChooser(startDirectory);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        if (fc.showOpenDialog(null) == 0) {
            files = fc.getSelectedFiles();
        }
        return files;
    }

    public static void forciblyRevalidate(Container container) {
        if (!(container instanceof Window)) {
            container = GUIServices.getParentWindow(container);
        }
        Dimension thisSize = container.getSize();
        ++thisSize.width;
        container.setSize(thisSize);
        --thisSize.width;
        container.setSize(thisSize);
    }

    public static void updateListRendererFonts(Container root, Font newFont) {
        Component[] componentArray = root.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JList) {
                JList jlist = (JList)c;
                ListCellRenderer oldRenderer = jlist.getCellRenderer();
                jlist.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                    Component comp = oldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    comp.setFont(newFont);
                    return comp;
                });
            } else if (c instanceof Container) {
                Container container = (Container)c;
                GUIServices.updateListRendererFonts(container, newFont);
            }
            ++n2;
        }
    }

    public static void updateContainerBackgroundColor(Container container, Color newColor) {
        if (container instanceof JComponent) {
            container.setBackground(newColor);
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof Container) {
                Container childContainer = (Container)child;
                GUIServices.updateContainerBackgroundColor(childContainer, newColor);
            }
            ++n2;
        }
    }

    public static void updateContainerForegroundColor(Container container, Color newColor) {
        if (container instanceof JComponent) {
            container.setForeground(newColor);
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof Container) {
                Container childContainer = (Container)child;
                GUIServices.updateContainerForegroundColor(childContainer, newColor);
            }
            ++n2;
        }
    }

    public static void updateMenuIcons(JMFrame frame, JMImageIcon oldIcon, JMImageIcon newIcon) {
        Component[] components;
        JMenuBar menuBar = frame.getJMenuBar();
        int menuCount = menuBar.getMenuCount();
        int menuIndex = 0;
        while (menuIndex < menuCount) {
            JMenu menu = menuBar.getMenu(menuIndex);
            GUIServices.updateMenuIcons(menu, oldIcon, newIcon);
            ++menuIndex;
        }
        JToolBar toolBar = frame.getToolBar();
        Component[] componentArray = components = toolBar.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            GUIServices.updateComponentIcon(component, oldIcon, newIcon);
            ++n2;
        }
    }

    private static void updateMenuIcons(JMenu menu, JMImageIcon oldIcon, JMImageIcon newIcon) {
        Component[] menuComponents = menu.getMenuComponents();
        int componentIndex = 0;
        while (componentIndex < menuComponents.length) {
            Component menuComponent = menuComponents[componentIndex];
            if (menuComponent instanceof JMenu) {
                JMenu subMenu = (JMenu)menuComponent;
                GUIServices.updateMenuIcons(subMenu, oldIcon, newIcon);
            } else if (menuComponent instanceof JMMenuItem) {
                GUIServices.updateComponentIcon(menuComponent, oldIcon, newIcon);
            }
            ++componentIndex;
        }
    }

    private static void updateComponentIcon(Component component, JMImageIcon oldIcon, JMImageIcon newIcon) {
        ToolBarButton toolBarButton;
        String fileName = oldIcon.getFileName();
        URL location = oldIcon.getUrl();
        JMImageIcon existingIcon = null;
        if (component instanceof JMMenuItem) {
            JMMenuItem menuItem = (JMMenuItem)component;
            existingIcon = (JMImageIcon)menuItem.getIcon();
            if (GUIServices.isIconMatching(existingIcon, fileName, location)) {
                menuItem.setIcon(newIcon);
            }
        } else if (component instanceof ToolBarButton && GUIServices.isIconMatching(existingIcon = (JMImageIcon)(toolBarButton = (ToolBarButton)component).getIcon(), fileName, location)) {
            toolBarButton.setIcon(newIcon);
        }
    }

    private static boolean isIconMatching(JMImageIcon icon, String fileName, URL location) {
        if (icon != null) {
            String existingFileName = icon.getFileName();
            URL existingLocation = icon.getUrl();
            if (fileName != null && existingFileName != null && fileName.equals(existingFileName)) {
                return true;
            }
            if (location != null && existingLocation != null && location.equals(existingLocation)) {
                return true;
            }
        }
        return false;
    }
}

