/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.util.HoverController;
import java.awt.Color;
import java.awt.Component;

public class HoverColorController
extends HoverController {
    public static final int COLOR = 0;
    public static final int BACKGROUND = 1;
    private Color oldColor;
    private Color hoverColor;
    private int colorStyle;

    public HoverColorController() {
        this(Color.YELLOW);
    }

    public HoverColorController(Color hoverColor) {
        this(hoverColor, 1);
    }

    public HoverColorController(Color hoverColor, int colorStyle) {
        this.setHoverColor(hoverColor);
        this.setColorStyle(colorStyle);
    }

    public Color getOldColor() {
        return this.oldColor;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color color) {
        this.hoverColor = color;
    }

    public int getColorStyle() {
        return this.colorStyle;
    }

    public void setColorStyle(int colorStyle) {
        switch (colorStyle) {
            case 0: 
            case 1: {
                this.colorStyle = colorStyle;
            }
        }
    }

    @Override
    public void mouseEntered(Component component) {
        Color color = this.oldColor = this.colorStyle == 1 ? component.getBackground() : component.getForeground();
        if (this.hoverColor != null) {
            if (this.colorStyle == 1) {
                component.setBackground(this.hoverColor);
            } else {
                component.setForeground(this.hoverColor);
            }
        }
    }

    @Override
    public void mouseExited(Component component) {
        if (this.oldColor != null) {
            if (this.colorStyle == 1) {
                component.setBackground(this.oldColor);
            } else {
                component.setForeground(this.oldColor);
            }
        }
    }
}

